package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PortworxVolumeSource represents a Portworx volume resource.
 *
 *  @param volumeID  volumeID uniquely identifies a Portworx volume
 *  @param   fsType  fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating
 *                   system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
 *  @param readOnly  readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
*/
case class PortworxVolumeSource(
  volumeID: String,
  fsType: Option[String] = None,
  readOnly: Option[Boolean] = None
)

object PortworxVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[PortworxVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[PortworxVolumeSource] = deriveDecoder
}
