package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
 *
 *  @param                          exec  Exec specifies the action to take.
 *  @param              failureThreshold  Minimum consecutive failures for the probe to be considered failed after having succeeded.
 *                                        Defaults to 3. Minimum value is 1.
 *  @param                          grpc  GRPC specifies an action involving a GRPC port.
 *  @param                       httpGet  HTTPGet specifies the http request to perform.
 *  @param           initialDelaySeconds  Number of seconds after the container has started before liveness probes are initiated.
 *                                        More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 *  @param                 periodSeconds  How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value
 *                                        is 1.
 *  @param              successThreshold  Minimum consecutive successes for the probe to be considered successful after having
 *                                        failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
 *  @param                     tcpSocket  TCPSocket specifies an action involving a TCP port.
 *  @param terminationGracePeriodSeconds  Optional duration in seconds the pod needs to terminate gracefully upon probe failure.
 *                                        The grace period is the duration in seconds after the processes running in the pod
 *                                        are sent a termination signal and the time when the processes are forcibly halted
 *                                        with a kill signal. Set this value longer than the expected cleanup time for your
 *                                        process. If this value is nil, the pod's terminationGracePeriodSeconds will be used.
 *                                        Otherwise, this value overrides the value provided by the pod spec. Value must be
 *                                        non-negative integer. The value zero indicates stop immediately via the kill signal
 *                                        (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod
 *                                        feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset
 *  @param                timeoutSeconds  Number of seconds after which the probe times out. Defaults to 1 second. Minimum
 *                                        value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
*/
case class Probe(
  exec: Option[io.k8s.api.core.v1.ExecAction] = None,
  failureThreshold: Option[Int] = None,
  grpc: Option[io.k8s.api.core.v1.GRPCAction] = None,
  httpGet: Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  initialDelaySeconds: Option[Int] = None,
  periodSeconds: Option[Int] = None,
  successThreshold: Option[Int] = None,
  tcpSocket: Option[io.k8s.api.core.v1.TCPSocketAction] = None,
  terminationGracePeriodSeconds: Option[Long] = None,
  timeoutSeconds: Option[Int] = None
)

object Probe {
  implicit lazy val encoder: Encoder.AsObject[Probe] = deriveEncoder
  implicit lazy val decoder: Decoder[Probe] = deriveDecoder
}
