package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicaSetCondition describes the state of a replica set at a certain point.
 *
 *  @param             `type`  Type of replica set condition.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param lastTransitionTime  The last time the condition transitioned from one status to another.
 *  @param            message  A human readable message indicating details about the transition.
 *  @param             reason  The reason for the condition's last transition.
*/
case class ReplicaSetCondition(
  `type`: String,
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object ReplicaSetCondition {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSetCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSetCondition] = deriveDecoder
}
