package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ResourceClaim references one entry in PodSpec.ResourceClaims.
 *
 *  @param    name  Name must match the name of one entry in pod.spec.resourceClaims of the Pod where this field is used. It
 *                  makes that resource available inside a container.
 *  @param request  Request is the name chosen for a request in the referenced claim. If empty, everything from the claim is
 *                  made available, otherwise only the result of this request.
*/
case class ResourceClaim(
  name: String,
  request: Option[String] = None
)

object ResourceClaim {
  implicit lazy val encoder: Encoder.AsObject[ResourceClaim] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceClaim] = deriveDecoder
}
