package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
 *
 *  @param          hard  hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
 *  @param scopeSelector  scopeSelector is also a collection of filters like scopes that must match each object tracked by
 *                        a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource
 *                        to match, both scopes AND scopeSelector (if specified in spec), must be matched.
 *  @param        scopes  A collection of filters that must match each object tracked by a quota. If not specified, the quota
 *                        matches all objects.
*/
case class ResourceQuotaSpec(
  hard: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  scopeSelector: Option[io.k8s.api.core.v1.ScopeSelector] = None,
  scopes: Option[Seq[String]] = None
)

object ResourceQuotaSpec {
  implicit lazy val encoder: Encoder.AsObject[ResourceQuotaSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceQuotaSpec] = deriveDecoder
}
