package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ResourceRequirements describes the compute resource requirements.
 *
 *  @param   claims  Claims lists the names of resources, defined in spec.resourceClaims, that are used by this container.
 *                   This is an alpha field and requires enabling the DynamicResourceAllocation feature gate.
 *                   This field is immutable. It can only be set for containers.
 *  @param   limits  Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 *  @param requests  Requests describes the minimum amount of compute resources required. If Requests is omitted for a container,
 *                   it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests
 *                   cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
*/
case class ResourceRequirements(
  claims: Option[Seq[io.k8s.api.core.v1.ResourceClaim]] = None,
  limits: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  requests: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object ResourceRequirements {
  implicit lazy val encoder: Encoder.AsObject[ResourceRequirements] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceRequirements] = deriveDecoder
}
