package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** 
 *
 *  @param      name  Name of the resource. Must be unique within the pod and match one of the resources from the pod spec.
 *  @param resources  List of unique Resources health. Each element in the list contains an unique resource ID and resource
 *                    health. At a minimum, ResourceID must uniquely identify the Resource allocated to the Pod on the Node
 *                    for the lifetime of a Pod. See ResourceID type for it's definition.
*/
case class ResourceStatus(
  name: String,
  resources: Option[Seq[io.k8s.api.core.v1.ResourceHealth]] = None
)

object ResourceStatus {
  implicit lazy val encoder: Encoder.AsObject[ResourceStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceStatus] = deriveDecoder
}
