package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       data  Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The
 *                     serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string)
 *                     data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
 *  @param  immutable  Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata
 *                     can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param stringData  stringData allows specifying non-binary secret data in string form. It is provided as a write-only input
 *                     field for convenience. All keys and values are merged into the data field on write, overwriting any existing
 *                     values. The stringData field is never output when reading from the API.
 *  @param     `type`  Used to facilitate programmatic handling of secret data. More info: https://kubernetes.io/docs/concepts/configuration/secret/#secret-types
*/
case class Secret(
  apiVersion: Option[String] = None,
  data: Option[Map[String, String]] = None,
  immutable: Option[Boolean] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  stringData: Option[Map[String, String]] = None,
  `type`: Option[String] = None
)

object Secret {
  implicit lazy val encoder: Encoder.AsObject[Secret] = deriveEncoder
  implicit lazy val decoder: Decoder[Secret] = deriveDecoder
}
