package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SecretEnvSource selects a Secret to populate the environment variables with.

The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
 *
 *  @param     name  Name of the referent. This field is effectively required, but due to backwards compatibility is allowed
 *                   to be empty. Instances of this type with an empty value here are almost certainly wrong. More info:
 *                   https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
 *  @param optional  Specify whether the Secret must be defined
*/
case class SecretEnvSource(
  name: Option[String] = None,
  optional: Option[Boolean] = None
)

object SecretEnvSource {
  implicit lazy val encoder: Encoder.AsObject[SecretEnvSource] = deriveEncoder
  implicit lazy val decoder: Decoder[SecretEnvSource] = deriveDecoder
}
