package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SecretKeySelector selects a key of a Secret.
 *
 *  @param      key  The key of the secret to select from.  Must be a valid secret key.
 *  @param     name  Name of the referent. This field is effectively required, but due to backwards compatibility is allowed
 *                   to be empty. Instances of this type with an empty value here are almost certainly wrong. More info:
 *                   https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
 *  @param optional  Specify whether the Secret or its key must be defined
*/
case class SecretKeySelector(
  key: String,
  name: Option[String] = None,
  optional: Option[Boolean] = None
)

object SecretKeySelector {
  implicit lazy val encoder: Encoder.AsObject[SecretKeySelector] = deriveEncoder
  implicit lazy val decoder: Decoder[SecretKeySelector] = deriveDecoder
}
