package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.
 *
 *  @param allowPrivilegeEscalation  AllowPrivilegeEscalation controls whether a process can gain more privileges than its
 *                                   parent process. This bool directly controls if the no_new_privs flag will be set on the
 *                                   container process. AllowPrivilegeEscalation is true always when the container is: 1) run
 *                                   as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set when spec.os.name
 *                                   is windows.
 *  @param          appArmorProfile  appArmorProfile is the AppArmor options to use by this container. If set, this profile
 *                                   overrides the pod's appArmorProfile. Note that this field cannot be set when spec.os.name
 *                                   is windows.
 *  @param             capabilities  The capabilities to add/drop when running containers. Defaults to the default set of capabilities
 *                                   granted by the container runtime. Note that this field cannot be set when spec.os.name
 *                                   is windows.
 *  @param               privileged  Run container in privileged mode. Processes in privileged containers are essentially equivalent
 *                                   to root on the host. Defaults to false. Note that this field cannot be set when spec.os.name
 *                                   is windows.
 *  @param                procMount  procMount denotes the type of proc mount to use for the containers. The default value
 *                                   is Default which uses the container runtime defaults for readonly paths and masked paths.
 *                                   This requires the ProcMountType feature flag to be enabled. Note that this field cannot
 *                                   be set when spec.os.name is windows.
 *  @param   readOnlyRootFilesystem  Whether this container has a read-only root filesystem. Default is false. Note that this
 *                                   field cannot be set when spec.os.name is windows.
 *  @param               runAsGroup  The GID to run the entrypoint of the container process. Uses runtime default if unset.
 *                                   May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext,
 *                                   the value specified in SecurityContext takes precedence. Note that this field cannot be
 *                                   set when spec.os.name is windows.
 *  @param             runAsNonRoot  Indicates that the container must run as a non-root user. If true, the Kubelet will validate
 *                                   the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the
 *                                   container if it does. If unset or false, no such validation will be performed. May also
 *                                   be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the
 *                                   value specified in SecurityContext takes precedence.
 *  @param                runAsUser  The UID to run the entrypoint of the container process. Defaults to user specified in
 *                                   image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext
 *                                   and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that
 *                                   this field cannot be set when spec.os.name is windows.
 *  @param           seLinuxOptions  The SELinux context to be applied to the container. If unspecified, the container runtime
 *                                   will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.
 *                                   If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext
 *                                   takes precedence. Note that this field cannot be set when spec.os.name is windows.
 *  @param           seccompProfile  The seccomp options to use by this container. If seccomp options are provided at both
 *                                   the pod & container level, the container options override the pod options. Note that this
 *                                   field cannot be set when spec.os.name is windows.
 *  @param           windowsOptions  The Windows specific settings applied to all containers. If unspecified, the options from
 *                                   the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext,
 *                                   the value specified in SecurityContext takes precedence. Note that this field cannot be
 *                                   set when spec.os.name is linux.
*/
case class SecurityContext(
  allowPrivilegeEscalation: Option[Boolean] = None,
  appArmorProfile: Option[io.k8s.api.core.v1.AppArmorProfile] = None,
  capabilities: Option[io.k8s.api.core.v1.Capabilities] = None,
  privileged: Option[Boolean] = None,
  procMount: Option[String] = None,
  readOnlyRootFilesystem: Option[Boolean] = None,
  runAsGroup: Option[Long] = None,
  runAsNonRoot: Option[Boolean] = None,
  runAsUser: Option[Long] = None,
  seLinuxOptions: Option[io.k8s.api.core.v1.SELinuxOptions] = None,
  seccompProfile: Option[io.k8s.api.core.v1.SeccompProfile] = None,
  windowsOptions: Option[io.k8s.api.core.v1.WindowsSecurityContextOptions] = None
)

object SecurityContext {
  implicit lazy val encoder: Encoder.AsObject[SecurityContext] = deriveEncoder
  implicit lazy val decoder: Decoder[SecurityContext] = deriveDecoder
}
