package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SelectableField specifies the JSON path of a field that may be used with field selectors.
 *
 *  @param jsonPath  jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector
 *                   value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean
 *                   or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field
 *                   in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
*/
case class SelectableField(
  jsonPath: String
)

object SelectableField {
  implicit lazy val encoder: Encoder.AsObject[SelectableField] = deriveEncoder
  implicit lazy val decoder: Decoder[SelectableField] = deriveDecoder
}
