package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ServiceBackendPort is the service port being referenced.
 *
 *  @param   name  name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
 *  @param number  number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with
 *                 "Name".
*/
case class ServiceBackendPort(
  name: Option[String] = None,
  number: Option[Int] = None
)

object ServiceBackendPort {
  implicit lazy val encoder: Encoder.AsObject[ServiceBackendPort] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceBackendPort] = deriveDecoder
}
