package io.k8s.api.networking.v1beta1

import io.circe.*
import io.circe.generic.semiauto.*

/** ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services.
 *
 *  @param cidrs  CIDRs defines the IP blocks in CIDR notation (e.g. "192.168.0.0/24" or "2001:db8::/64") from which to assign
 *                service cluster IPs. Max of two CIDRs is allowed, one of each IP family. This field is immutable.
*/
case class ServiceCIDRSpec(
  cidrs: Option[Seq[String]] = None
)

object ServiceCIDRSpec {
  implicit lazy val encoder: Encoder.AsObject[ServiceCIDRSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceCIDRSpec] = deriveDecoder
}
