package io.k8s.api.networking.v1beta1

import io.circe.*
import io.circe.generic.semiauto.*

/** ServiceCIDRStatus describes the current state of the ServiceCIDR.
 *
 *  @param conditions  conditions holds an array of metav1.Condition that describe the state of the ServiceCIDR. Current service
 *                     state
*/
case class ServiceCIDRStatus(
  conditions: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None
)

object ServiceCIDRStatus {
  implicit lazy val encoder: Encoder.AsObject[ServiceCIDRStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceCIDRStatus] = deriveDecoder
}
