package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SleepAction describes a "sleep" action.
 *
 *  @param seconds  Seconds is the number of seconds to sleep.
*/
case class SleepAction(
  seconds: Long
)

object SleepAction {
  implicit lazy val encoder: Encoder.AsObject[SleepAction] = deriveEncoder
  implicit lazy val decoder: Decoder[SleepAction] = deriveDecoder
}
