package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** StatefulSetCondition describes the state of a statefulset at a certain point.
 *
 *  @param             `type`  Type of statefulset condition.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param lastTransitionTime  Last time the condition transitioned from one status to another.
 *  @param            message  A human readable message indicating details about the transition.
 *  @param             reason  The reason for the condition's last transition.
*/
case class StatefulSetCondition(
  `type`: String,
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object StatefulSetCondition {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetCondition] = deriveDecoder
}
