package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
 *
 *  @param start  start is the number representing the first replica's index. It may be used to number replicas from an alternate
 *                index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas
 *                from one StatefulSet to another. If set, replica indices will be in the range:
 *                [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
 *                If unset, defaults to 0. Replica indices will be in the range:
 *                [0, .spec.replicas).
*/
case class StatefulSetOrdinals(
  start: Option[Int] = None
)

object StatefulSetOrdinals {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetOrdinals] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetOrdinals] = deriveDecoder
}
