package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Status is a return value for calls that don't return other objects.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       code  Suggested HTTP return code for this status, 0 if not set.
 *  @param    details  Extended data associated with the reason.  Each reason may define its own extended details. This field
 *                     is optional and the data returned is not guaranteed to conform to any schema except that defined by the
 *                     reason type.
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param    message  A human-readable description of the status of this operation.
 *  @param   metadata  Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param     reason  A machine-readable description of why this operation is in the "Failure" status. If this value is empty
 *                     there is no information available. A Reason clarifies an HTTP status code but does not override it.
 *  @param     status  Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class Status(
  apiVersion: Option[String] = None,
  code: Option[Int] = None,
  details: Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = None,
  kind: Option[String] = None,
  message: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None,
  reason: Option[String] = None,
  status: Option[String] = None
)

object Status {
  implicit lazy val encoder: Encoder.AsObject[Status] = deriveEncoder
  implicit lazy val decoder: Decoder[Status] = deriveDecoder
}
