package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint.
 *
 *  @param       key  Required. The taint key to be applied to a node.
 *  @param    effect  Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule,
 *                    PreferNoSchedule and NoExecute.
 *  @param timeAdded  TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.
 *  @param     value  The taint value corresponding to the taint key.
*/
case class Taint(
  key: String,
  effect: String,
  timeAdded: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  value: Option[String] = None
)

object Taint {
  implicit lazy val encoder: Encoder.AsObject[Taint] = deriveEncoder
  implicit lazy val decoder: Decoder[Taint] = deriveDecoder
}
