package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** TokenRequest contains parameters of a service account token.
 *
 *  @param          audience  audience is the intended audience of the token in "TokenRequestSpec". It will default to the
 *                            audiences of kube apiserver.
 *  @param expirationSeconds  expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the
 *                            same default value of "ExpirationSeconds" in "TokenRequestSpec".
*/
case class TokenRequest(
  audience: String,
  expirationSeconds: Option[Long] = None
)

object TokenRequest {
  implicit lazy val encoder: Encoder.AsObject[TokenRequest] = deriveEncoder
  implicit lazy val decoder: Decoder[TokenRequest] = deriveDecoder
}
