package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future.
 *
 *  @param    key  The label key that the selector applies to.
 *  @param values  An array of string values. One value must match the label to be selected. Each entry in Values is ORed.
*/
case class TopologySelectorLabelRequirement(
  key: String,
  values: Seq[String]
)

object TopologySelectorLabelRequirement {
  implicit lazy val encoder: Encoder.AsObject[TopologySelectorLabelRequirement] = deriveEncoder
  implicit lazy val decoder: Decoder[TopologySelectorLabelRequirement] = deriveDecoder
}
