package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.
 *
 *  @param     kind  Kind is the type of resource being referenced
 *  @param     name  Name is the name of resource being referenced
 *  @param apiGroup  APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind
 *                   must be in the core API group. For any other third-party types, APIGroup is required.
*/
case class TypedLocalObjectReference(
  kind: String,
  name: String,
  apiGroup: Option[String] = None
)

object TypedLocalObjectReference {
  implicit lazy val encoder: Encoder.AsObject[TypedLocalObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[TypedLocalObjectReference] = deriveDecoder
}
