package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** 
 *
 *  @param      kind  Kind is the type of resource being referenced
 *  @param      name  Name is the name of resource being referenced
 *  @param  apiGroup  APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified
 *                    Kind must be in the core API group. For any other third-party types, APIGroup is required.
 *  @param namespace  Namespace is the namespace of resource being referenced Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant
 *                    object is required in the referent namespace to allow that namespace's owner to accept the reference.
 *                    See the ReferenceGrant documentation for details. (Alpha) This field requires the CrossNamespaceVolumeDataSource
 *                    feature gate to be enabled.
*/
case class TypedObjectReference(
  kind: String,
  name: String,
  apiGroup: Option[String] = None,
  namespace: Option[String] = None
)

object TypedObjectReference {
  implicit lazy val encoder: Encoder.AsObject[TypedObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[TypedObjectReference] = deriveDecoder
}
