package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Volume represents a named volume in a pod that may be accessed by any container in the pod.
 *
 *  @param                  name  name of the volume. Must be a DNS_LABEL and unique within the pod. More info:
 *                                https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
 *  @param  awsElasticBlockStore  awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host
 *                                machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
 *  @param             azureDisk  azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
 *  @param             azureFile  azureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *  @param                cephfs  cephFS represents a Ceph FS mount on the host that shares a pod's lifetime
 *  @param                cinder  cinder represents a cinder volume attached and mounted on kubelets host machine. More info:
 *                                https://examples.k8s.io/mysql-cinder-pd/README.md
 *  @param             configMap  configMap represents a configMap that should populate this volume
 *  @param                   csi  csi (Container Storage Interface) represents ephemeral storage that is handled by certain
 *                                external CSI drivers (Beta feature).
 *  @param           downwardAPI  downwardAPI represents downward API about the pod that should populate this volume
 *  @param              emptyDir  emptyDir represents a temporary directory that shares a pod's lifetime. More info:
 *                                https://kubernetes.io/docs/concepts/storage/volumes#emptydir
 *  @param             ephemeral  ephemeral represents a volume that is handled by a cluster storage driver. The volume's lifecycle
 *                                is tied to the pod that defines it - it will be created before the pod starts, and deleted
 *                                when the pod is removed.
 *                                Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes
 *                                like restoring from snapshot or capacity
 *                                tracking are needed,
 *                                c) the storage driver is specified through a storage class, and d) the storage driver supports
 *                                dynamic volume provisioning through
 *                                a PersistentVolumeClaim (see EphemeralVolumeSource for more
 *                                information on the connection between this volume type
 *                                and PersistentVolumeClaim).
 *                                Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for
 *                                longer than the lifecycle of an individual pod.
 *                                Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that
 *                                way - see the documentation of the driver for more information.
 *                                A pod can use both types of ephemeral volumes and persistent volumes at the same time.
 *  @param                    fc  fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then
 *                                exposed to the pod.
 *  @param            flexVolume  flexVolume represents a generic volume resource that is provisioned/attached using an exec
 *                                based plugin.
 *  @param               flocker  flocker represents a Flocker volume attached to a kubelet's host machine. This depends on
 *                                the Flocker control service being running
 *  @param     gcePersistentDisk  gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine
 *                                and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
 *  @param               gitRepo  gitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated.
 *                                To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones
 *                                the repo using git, then mount the EmptyDir into the Pod's container.
 *  @param             glusterfs  glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info:
 *                                https://examples.k8s.io/volumes/glusterfs/README.md
 *  @param              hostPath  hostPath represents a pre-existing file or directory on the host machine that is directly
 *                                exposed to the container. This is generally used for system agents or other privileged things
 *                                that are allowed to see the host machine. Most containers will NOT need this. More info:
 *                                https://kubernetes.io/docs/concepts/storage/volumes#hostpath
 *  @param                 image  image represents an OCI object (a container image or artifact) pulled and mounted on the
 *                                kubelet's host machine. The volume is resolved at pod startup depending on which PullPolicy
 *                                value is provided:
 *                                - Always: the kubelet always attempts to pull the reference. Container creation will fail
 *                                If the pull fails. - Never: the kubelet never pulls the reference and only uses a local image
 *                                or artifact. Container creation will fail if the reference isn't present. - IfNotPresent:
 *                                the kubelet pulls if the reference isn't already present on disk. Container creation will
 *                                fail if the reference isn't present and the pull fails.
 *                                The volume gets re-resolved if the pod gets deleted and recreated, which means that new remote
 *                                content will become available on pod recreation. A failure to resolve or pull the image during
 *                                pod startup will block containers from starting and may add significant latency. Failures
 *                                will be retried using normal volume backoff and will be reported on the pod reason and message.
 *                                The types of objects that may be mounted by this volume are defined by the container runtime
 *                                implementation on a host machine and at minimum must include all valid types supported by
 *                                the container image field. The OCI object gets mounted in a single directory (spec.containers[*].volumeMounts.mountPath)
 *                                by merging the manifest layers in the same way as for container images. The volume will be
 *                                mounted read-only (ro) and non-executable files (noexec). Sub path mounts for containers are
 *                                not supported (spec.containers[*].volumeMounts.subpath). The field spec.securityContext.fsGroupChangePolicy
 *                                has no effect on this volume type.
 *  @param                 iscsi  iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and
 *                                then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
 *  @param                   nfs  nfs represents an NFS mount on the host that shares a pod's lifetime More info:
 *                                https://kubernetes.io/docs/concepts/storage/volumes#nfs
 *  @param persistentVolumeClaim  persistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the
 *                                same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
 *  @param  photonPersistentDisk  photonPersistentDisk represents a PhotonController persistent disk attached and mounted on
 *                                kubelets host machine
 *  @param        portworxVolume  portworxVolume represents a portworx volume attached and mounted on kubelets host machine
 *  @param             projected  projected items for all in one resources secrets, configmaps, and downward API
 *  @param               quobyte  quobyte represents a Quobyte mount on the host that shares a pod's lifetime
 *  @param                   rbd  rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. More
 *                                info: https://examples.k8s.io/volumes/rbd/README.md
 *  @param               scaleIO  scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
 *  @param                secret  secret represents a secret that should populate this volume. More info:
 *                                https://kubernetes.io/docs/concepts/storage/volumes#secret
 *  @param             storageos  storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
 *  @param         vsphereVolume  vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
*/
case class Volume(
  name: String,
  awsElasticBlockStore: Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  azureDisk: Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  azureFile: Option[io.k8s.api.core.v1.AzureFileVolumeSource] = None,
  cephfs: Option[io.k8s.api.core.v1.CephFSVolumeSource] = None,
  cinder: Option[io.k8s.api.core.v1.CinderVolumeSource] = None,
  configMap: Option[io.k8s.api.core.v1.ConfigMapVolumeSource] = None,
  csi: Option[io.k8s.api.core.v1.CSIVolumeSource] = None,
  downwardAPI: Option[io.k8s.api.core.v1.DownwardAPIVolumeSource] = None,
  emptyDir: Option[io.k8s.api.core.v1.EmptyDirVolumeSource] = None,
  ephemeral: Option[io.k8s.api.core.v1.EphemeralVolumeSource] = None,
  fc: Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  flexVolume: Option[io.k8s.api.core.v1.FlexVolumeSource] = None,
  flocker: Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  gcePersistentDisk: Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  gitRepo: Option[io.k8s.api.core.v1.GitRepoVolumeSource] = None,
  glusterfs: Option[io.k8s.api.core.v1.GlusterfsVolumeSource] = None,
  hostPath: Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  image: Option[io.k8s.api.core.v1.ImageVolumeSource] = None,
  iscsi: Option[io.k8s.api.core.v1.ISCSIVolumeSource] = None,
  nfs: Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  persistentVolumeClaim: Option[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = None,
  photonPersistentDisk: Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  portworxVolume: Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  projected: Option[io.k8s.api.core.v1.ProjectedVolumeSource] = None,
  quobyte: Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  rbd: Option[io.k8s.api.core.v1.RBDVolumeSource] = None,
  scaleIO: Option[io.k8s.api.core.v1.ScaleIOVolumeSource] = None,
  secret: Option[io.k8s.api.core.v1.SecretVolumeSource] = None,
  storageos: Option[io.k8s.api.core.v1.StorageOSVolumeSource] = None,
  vsphereVolume: Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None
)

object Volume {
  implicit lazy val encoder: Encoder.AsObject[Volume] = deriveEncoder
  implicit lazy val decoder: Decoder[Volume] = deriveDecoder
}
