package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
 *
 *  @param     inlineVolumeSpec  inlineVolumeSpec contains all the information necessary to attach a persistent volume defined
 *                               by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature.
 *                               It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This
 *                               field is beta-level and is only honored by servers that enabled the CSIMigration feature.
 *  @param persistentVolumeName  persistentVolumeName represents the name of the persistent volume to attach.
*/
case class VolumeAttachmentSource(
  inlineVolumeSpec: Option[io.k8s.api.core.v1.PersistentVolumeSpec] = None,
  persistentVolumeName: Option[String] = None
)

object VolumeAttachmentSource {
  implicit lazy val encoder: Encoder.AsObject[VolumeAttachmentSource] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeAttachmentSource] = deriveDecoder
}
