package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeAttachmentSpec is the specification of a VolumeAttachment request.
 *
 *  @param attacher  attacher indicates the name of the volume driver that MUST handle this request. This is the name returned
 *                   by GetPluginName().
 *  @param   source  source represents the volume that should be attached.
 *  @param nodeName  nodeName represents the node that the volume should be attached to.
*/
case class VolumeAttachmentSpec(
  attacher: String,
  source: io.k8s.api.storage.v1.VolumeAttachmentSource,
  nodeName: String
)

object VolumeAttachmentSpec {
  implicit lazy val encoder: Encoder.AsObject[VolumeAttachmentSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeAttachmentSpec] = deriveDecoder
}
