package io.k8s.api.storage.v1alpha1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeAttributesClass represents a specification of mutable volume attributes defined by the CSI driver. The class can be specified during dynamic provisioning of PersistentVolumeClaims, and changed in the PersistentVolumeClaim spec after provisioning.
 *
 *  @param driverName  Name of the CSI driver This field is immutable.
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param parameters  parameters hold volume attributes defined by the CSI driver. These values are opaque to the Kubernetes
 *                     and are passed directly to the CSI driver. The underlying storage provider supports changing these attributes
 *                     on an existing volume, however the parameters field itself is immutable. To invoke a volume update, a
 *                     new VolumeAttributesClass should be created with new parameters, and the PersistentVolumeClaim should
 *                     be updated to reference the new VolumeAttributesClass.
 *                     This field is required and must contain at least one key/value pair. The keys cannot be empty, and the
 *                     maximum number of parameters is 512, with a cumulative max size of 256K. If the CSI driver rejects invalid
 *                     parameters, the target PersistentVolumeClaim will be set to an "Infeasible" state in the modifyVolumeStatus
 *                     field.
*/
case class VolumeAttributesClass(
  driverName: String,
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  parameters: Option[Map[String, String]] = None
)

object VolumeAttributesClass {
  implicit lazy val encoder: Encoder.AsObject[VolumeAttributesClass] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeAttributesClass] = deriveDecoder
}
