package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeError captures an error encountered during a volume operation.
 *
 *  @param message  message represents the error encountered during Attach or Detach operation. This string may be logged,
 *                  so it should not contain sensitive information.
 *  @param    time  time represents the time the error was encountered.
*/
case class VolumeError(
  message: Option[String] = None,
  time: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object VolumeError {
  implicit lazy val encoder: Encoder.AsObject[VolumeError] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeError] = deriveDecoder
}
