package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeMountStatus shows status of volume mounts.
 *
 *  @param              name  Name corresponds to the name of the original VolumeMount.
 *  @param         mountPath  MountPath corresponds to the original VolumeMount.
 *  @param          readOnly  ReadOnly corresponds to the original VolumeMount.
 *  @param recursiveReadOnly  RecursiveReadOnly must be set to Disabled, Enabled, or unspecified (for non-readonly mounts).
 *                            An IfPossible value in the original VolumeMount must be translated to Disabled or Enabled, depending
 *                            on the mount result.
*/
case class VolumeMountStatus(
  name: String,
  mountPath: String,
  readOnly: Option[Boolean] = None,
  recursiveReadOnly: Option[String] = None
)

object VolumeMountStatus {
  implicit lazy val encoder: Encoder.AsObject[VolumeMountStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeMountStatus] = deriveDecoder
}
