package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Projection that may be projected along with other supported volume types. Exactly one of these fields must be set.
 *
 *  @param  clusterTrustBundle  ClusterTrustBundle allows a pod to access the `.spec.trustBundle` field of ClusterTrustBundle
 *                              objects in an auto-updating file.
 *                              Alpha, gated by the ClusterTrustBundleProjection feature gate.
 *                              ClusterTrustBundle objects can either be selected by name, or by the combination of signer name
 *                              and a label selector.
 *                              Kubelet performs aggressive normalization of the PEM contents written into the pod filesystem.
 *                              Esoteric PEM features such as inter-block comments and block headers are stripped.  Certificates
 *                              are deduplicated. The ordering of certificates within the file is arbitrary, and Kubelet may
 *                              change the order over time.
 *  @param           configMap  configMap information about the configMap data to project
 *  @param         downwardAPI  downwardAPI information about the downwardAPI data to project
 *  @param              secret  secret information about the secret data to project
 *  @param serviceAccountToken  serviceAccountToken is information about the serviceAccountToken data to project
*/
case class VolumeProjection(
  clusterTrustBundle: Option[io.k8s.api.core.v1.ClusterTrustBundleProjection] = None,
  configMap: Option[io.k8s.api.core.v1.ConfigMapProjection] = None,
  downwardAPI: Option[io.k8s.api.core.v1.DownwardAPIProjection] = None,
  secret: Option[io.k8s.api.core.v1.SecretProjection] = None,
  serviceAccountToken: Option[io.k8s.api.core.v1.ServiceAccountTokenProjection] = None
)

object VolumeProjection {
  implicit lazy val encoder: Encoder.AsObject[VolumeProjection] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeProjection] = deriveDecoder
}
