package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeResourceRequirements describes the storage resource requirements for a volume.
 *
 *  @param   limits  Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 *  @param requests  Requests describes the minimum amount of compute resources required. If Requests is omitted for a container,
 *                   it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests
 *                   cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
*/
case class VolumeResourceRequirements(
  limits: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  requests: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object VolumeResourceRequirements {
  implicit lazy val encoder: Encoder.AsObject[VolumeResourceRequirements] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeResourceRequirements] = deriveDecoder
}
