/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant;
import cats.Invariant$;
import cats.Monad;
import cats.MonadError;
import cats.NonEmptyParallel$;
import cats.Semigroupal;
import cats.Semigroupal$;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.package;
import cats.syntax.EitherOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.ParallelSequenceOps1$;
import cats.syntax.package;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.KubeConfigNotFoundError$;
import com.goyeau.kubernetes.client.util.AuthInfoExec;
import com.goyeau.kubernetes.client.util.Text$;
import com.goyeau.kubernetes.client.util.Yamls$;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.Credentials;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.headers.Authorization$;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class KubeConfig$
implements Mirror.Product,
Serializable {
    private static final String EnvKubeConfig;
    private static final String EnvHome;
    private static final String EnvHomeDrive;
    private static final String EnvHomePath;
    private static final String EnvUserProfile;
    private static final String KubeConfigDir;
    private static final String KubeConfigFile;
    private static final String ServiceAccountCAPath;
    private static final String ServiceAccountTokenPath;
    private static final String EnvServiceHost;
    private static final String EnvServicePort;
    public static final KubeConfig$ MODULE$;

    private KubeConfig$() {
    }

    static {
        MODULE$ = new KubeConfig$();
        EnvKubeConfig = "KUBECONFIG";
        EnvHome = "HOME";
        EnvHomeDrive = "HOMEDRIVE";
        EnvHomePath = "HOMEPATH";
        EnvUserProfile = "USERPROFILE";
        KubeConfigDir = ".kube";
        KubeConfigFile = "config";
        String ServiceAccountRoot = "/var/run/secrets/kubernetes.io/serviceaccount";
        ServiceAccountCAPath = ServiceAccountRoot + "/ca.crt";
        ServiceAccountTokenPath = ServiceAccountRoot + "/token";
        EnvServiceHost = "KUBERNETES_SERVICE_HOST";
        EnvServicePort = "KUBERNETES_SERVICE_PORT";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KubeConfig$.class);
    }

    private <F> KubeConfig<F> apply(Uri server, Option<Object> authorization, Option<String> caCertData, Option<Path> caCertFile, Option<String> clientCertData, Option<Path> clientCertFile, Option<String> clientKeyData, Option<Path> clientKeyFile, Option<String> clientKeyPass, Option<AuthInfoExec> authInfoExec, Option<Function1<Object, Object>> authorizationCache) {
        return new KubeConfig(server, authorization, caCertData, caCertFile, clientCertData, clientCertFile, clientKeyData, clientKeyFile, clientKeyPass, authInfoExec, authorizationCache);
    }

    public <F> KubeConfig<F> unapply(KubeConfig<F> x$1) {
        return x$1;
    }

    public <F> Object standard(Logger<F> evidence$1, Async<F> F) {
        return this.findFromEnv(evidence$1, F).orElse(() -> KubeConfig$.standard$$anonfun$1(evidence$1, F), F).orElse(() -> KubeConfig$.standard$$anonfun$2(evidence$1, F), F).getOrRaise(KubeConfig$::standard$$anonfun$3, F);
    }

    public <F> Object fromEnv(Logger<F> evidence$1, Async<F> F) {
        return this.findFromEnv(evidence$1, F).getOrRaise(KubeConfig$::fromEnv$$anonfun$1, F);
    }

    public <F> Object inHomeDir(Logger<F> evidence$1, Async<F> F) {
        return this.findConfigInHomeDir((Option<String>)package.all$.MODULE$.none(), evidence$1, F).getOrRaise(KubeConfig$::inHomeDir$$anonfun$1, F);
    }

    public <F> Object inHomeDir(String contextName, Logger<F> evidence$1, Async<F> F) {
        String string = (String)package.all$.MODULE$.catsSyntaxOptionId((Object)contextName);
        return this.findConfigInHomeDir((Option<String>)OptionIdOps$.MODULE$.some$extension((Object)string), evidence$1, F).getOrRaise(KubeConfig$::inHomeDir$$anonfun$2, F);
    }

    public <F> Object cluster(Logger<F> evidence$1, Async<F> F) {
        return this.findClusterConfig(evidence$1, F).getOrRaise(KubeConfig$::cluster$$anonfun$1, F);
    }

    public <F> Object fromFile(Path kubeconfig, Async<F> evidence$1, Logger<F> evidence$2) {
        return Yamls$.MODULE$.fromKubeConfigFile(kubeconfig, (Option<String>)None$.MODULE$, evidence$1, evidence$2, Files$.MODULE$.implicitForAsync(evidence$1));
    }

    public <F> Object fromFile(Path kubeconfig, String contextName, Async<F> evidence$1, Logger<F> evidence$2) {
        return Yamls$.MODULE$.fromKubeConfigFile(kubeconfig, (Option<String>)Option$.MODULE$.apply((Object)contextName), evidence$1, evidence$2, Files$.MODULE$.implicitForAsync(evidence$1));
    }

    public <F> Object apply(Path kubeconfig, Async<F> evidence$1, Logger<F> evidence$2) {
        return this.fromFile(kubeconfig, evidence$1, evidence$2);
    }

    public <F> Object apply(Path kubeconfig, String contextName, Async<F> evidence$1, Logger<F> evidence$2) {
        return this.fromFile(kubeconfig, contextName, evidence$1, evidence$2);
    }

    public <F> Object of(Uri server, Option<Object> authorization, Option<String> caCertData, Option<Path> caCertFile, Option<String> clientCertData, Option<Path> clientCertFile, Option<String> clientKeyData, Option<Path> clientKeyFile, Option<String> clientKeyPass, Option<AuthInfoExec> authInfoExec, ApplicativeError<F, Throwable> evidence$1) {
        Boolean bl = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(caCertData, caCertFile)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined()));
        Boolean bl2 = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(clientCertData, clientCertFile)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined()));
        Boolean bl3 = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(clientKeyData, clientKeyFile)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined()));
        Boolean bl4 = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(authorization, authInfoExec)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined()));
        Boolean bl5 = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)authInfoExec.exists((Function1 & Serializable)_$13 -> _$13.interactiveMode().contains((Object)"Always"))));
        Boolean bl6 = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)authInfoExec.exists((Function1 & Serializable)_$14 -> _$14.provideClusterInfo().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        List list = (List)package.all$.MODULE$.catsSyntaxParallelSequence1((Object)((List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl, (Object)"caCertData and caCertFile cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl2, (Object)"clientCertData and clientCertFile cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl3, (Object)"clientKeyData and clientKeyFile cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl4, (Object)"authorization and authInfoExec cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl5, (Object)"interactiveMode=Always is not supported"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl6, (Object)"provideClusterInfo=true is not supported"), (List)Nil$.MODULE$))))))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                boolean badCondition = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
                String error = (String)tuple2._2();
                return package$.MODULE$.Either().cond(!badCondition, (Function0 & Serializable)() -> {
                    KubeConfig$.$anonfun$4$$anonfun$1();
                    return BoxedUnit.UNIT;
                }, () -> KubeConfig$.$anonfun$4$$anonfun$2(error));
            }
            throw new MatchError((Object)tuple2);
        }), UnorderedFoldable$.MODULE$.catsTraverseForList());
        Either either = package.all$.MODULE$.catsSyntaxEither((Either)ParallelSequenceOps1$.MODULE$.parSequence$extension((Object)list, UnorderedFoldable$.MODULE$.catsTraverseForList(), NonEmptyParallel$.MODULE$.catsParallelForEitherValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList())));
        Either configOrError = (Either)package.all$.MODULE$.toFunctorOps((Object)EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)errors -> new IllegalArgumentException(errors.toList().mkString("; "))), (Functor)Invariant$.MODULE$.catsMonadErrorForEither()).as(this.apply(server, authorization, caCertData, caCertFile, clientCertData, clientCertFile, clientKeyData, clientKeyFile, clientKeyPass, authInfoExec, (Option<Function1<Object, Object>>)package.all$.MODULE$.none()));
        return package.ApplicativeThrow$.MODULE$.apply(evidence$1).fromEither(configOrError);
    }

    public <F> None$ of$default$2() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$3() {
        return None$.MODULE$;
    }

    public <F> Option<Path> of$default$4() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$5() {
        return None$.MODULE$;
    }

    public <F> Option<Path> of$default$6() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$7() {
        return None$.MODULE$;
    }

    public <F> Option<Path> of$default$8() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$9() {
        return None$.MODULE$;
    }

    public <F> Option<AuthInfoExec> of$default$10() {
        return None$.MODULE$;
    }

    private <F> OptionT<F, KubeConfig<F>> findFromEnv(Logger<F> evidence$1, Async<F> F) {
        return this.envPath(EnvKubeConfig, F).flatMapF((Function1 & Serializable)_$16 -> MODULE$.checkExists((Path)_$16, F), F).flatTapNone(() -> KubeConfig$.findFromEnv$$anonfun$2(evidence$1), F).semiflatTap((Function1 & Serializable)path -> Logger$.MODULE$.apply(evidence$1).debug(() -> KubeConfig$.findFromEnv$$anonfun$3$$anonfun$1(path)), F).semiflatMap((Function1 & Serializable)_$17 -> MODULE$.fromFile((Path)_$17, F, evidence$1), F);
    }

    private <F> OptionT<F, KubeConfig<F>> findConfigInHomeDir(Option<String> contextName, Logger<F> evidence$1, Async<F> F) {
        return this.findHomeDir(evidence$1, F).map((Function1 & Serializable)homeDir -> homeDir.resolve(KubeConfigDir).resolve(KubeConfigFile), F).flatMapF((Function1 & Serializable)_$19 -> MODULE$.checkExists((Path)_$19, F), F).flatTapNone(() -> KubeConfig$.findConfigInHomeDir$$anonfun$3(evidence$1), F).semiflatTap((Function1 & Serializable)path -> Logger$.MODULE$.apply(evidence$1).debug(() -> KubeConfig$.findConfigInHomeDir$$anonfun$4$$anonfun$1(path)), F).semiflatMap((Function1 & Serializable)path -> contextName.fold(() -> KubeConfig$.findConfigInHomeDir$$anonfun$5$$anonfun$1(path, F, evidence$1), (Function1 & Serializable)_$20 -> MODULE$.fromFile((Path)path, (String)_$20, F, evidence$1)), F);
    }

    private <F> OptionT<F, KubeConfig<F>> findClusterConfig(Logger<F> evidence$1, Async<F> F) {
        return ((OptionT)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)this.path(ServiceAccountTokenPath, F).flatMapF((Function1 & Serializable)_$22 -> MODULE$.checkExists((Path)_$22, F), F).flatTapNone(() -> KubeConfig$.findClusterConfig$$anonfun$2(evidence$1), F), (Object)this.path(ServiceAccountCAPath, F).flatMapF((Function1 & Serializable)_$23 -> MODULE$.checkExists((Path)_$23, F), F).flatTapNone(() -> KubeConfig$.findClusterConfig$$anonfun$4(evidence$1), F), (Object)this.env(EnvServiceHost, F).mapFilter((Function1 & Serializable)value -> IpAddress$.MODULE$.fromString(value), F).map((Function1 & Serializable)value -> Uri.Host$.MODULE$.fromIpAddress(value), F).flatTapNone(() -> KubeConfig$.findClusterConfig$$anonfun$7(evidence$1), F), (Object)this.env(EnvServicePort, F).mapFilter((Function1 & Serializable)value -> Port$.MODULE$.fromString(value), F).flatTapNone(() -> KubeConfig$.findClusterConfig$$anonfun$9(evidence$1), F))).tupled((Invariant)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F), (Semigroupal)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F))).semiflatTap((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                Path tokenPath = (Path)tuple4._1();
                Path caPath = (Path)tuple4._2();
                Uri.Host serviceHost = (Uri.Host)tuple4._3();
                Port servicePort = (Port)tuple4._4();
                return Logger$.MODULE$.apply(evidence$1).debug(() -> KubeConfig$.findClusterConfig$$anonfun$10$$anonfun$1(serviceHost, servicePort, tokenPath, caPath));
            }
            throw new MatchError((Object)tuple4);
        }, F).semiflatMap((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                Path tokenPath = (Path)tuple4._1();
                Path caPath = (Path)tuple4._2();
                Uri.Host serviceHost = (Uri.Host)tuple4._3();
                Port servicePort = (Port)tuple4._4();
                Uri.Scheme scheme = (Uri.Scheme)package.all$.MODULE$.catsSyntaxOptionId((Object)Uri.Scheme$.MODULE$.https());
                Integer n = (Integer)package.all$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToInteger((int)servicePort.value()));
                Option option = OptionIdOps$.MODULE$.some$extension((Object)n);
                Option option2 = Uri.Authority$.MODULE$.$lessinit$greater$default$1();
                Uri.Authority authority = (Uri.Authority)package.all$.MODULE$.catsSyntaxOptionId((Object)Uri.Authority$.MODULE$.apply(option2, serviceHost, option));
                Uri uri = Uri$.MODULE$.apply(OptionIdOps$.MODULE$.some$extension((Object)scheme), OptionIdOps$.MODULE$.some$extension((Object)authority), Uri$.MODULE$.$lessinit$greater$default$3(), Uri$.MODULE$.$lessinit$greater$default$4(), Uri$.MODULE$.$lessinit$greater$default$5());
                Object object = package.all$.MODULE$.catsSyntaxOptionId(package.all$.MODULE$.toFunctorOps(Text$.MODULE$.readFile(tokenPath, F, Files$.MODULE$.implicitForAsync(F)), (Functor)F).map((Function1 & Serializable)token -> Authorization$.MODULE$.apply((Credentials)Credentials.Token$.MODULE$.apply(AuthScheme$.MODULE$.Bearer(), token))));
                Option option3 = OptionIdOps$.MODULE$.some$extension(object);
                Path path = (Path)package.all$.MODULE$.catsSyntaxOptionId((Object)caPath);
                Option option4 = OptionIdOps$.MODULE$.some$extension((Object)path);
                Option<String> option5 = this.of$default$3();
                Option<String> option6 = this.of$default$5();
                Option<Path> option7 = this.of$default$6();
                Option<String> option8 = this.of$default$7();
                Option<Path> option9 = this.of$default$8();
                Option<String> option10 = this.of$default$9();
                Option<AuthInfoExec> option11 = this.of$default$10();
                return this.of(uri, (Option<Object>)option3, option5, (Option<Path>)option4, option6, option7, option8, option9, option10, option11, (ApplicativeError)F);
            }
            throw new MatchError((Object)tuple4);
        }, F);
    }

    private <F> OptionT<F, Path> findHomeDir(Logger<F> evidence$1, Async<F> F) {
        OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxFlatMapOps((Object)OptionT$.MODULE$.liftF(Logger$.MODULE$.apply(evidence$1).debug(KubeConfig$::findHomeDir$$anonfun$1), F), (FlatMap)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F));
        return (OptionT)FlatMapOps$.MODULE$.$greater$greater$extension((Object)optionT, () -> KubeConfig$.findHomeDir$$anonfun$2(F, evidence$1), (FlatMap)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F));
    }

    private <F> OptionT<F, String> sysProp(String name, Async<F> F) {
        return OptionT$.MODULE$.apply(F.delay(() -> KubeConfig$.sysProp$$anonfun$1(name)));
    }

    private <F> OptionT<F, String> env(String name, Async<F> F) {
        return OptionT$.MODULE$.apply(F.delay(() -> KubeConfig$.env$$anonfun$1(name)));
    }

    private <F> OptionT<F, Path> path(String path, Async<F> evidence$1) {
        boolean bl = OptionT$.MODULE$.pure();
        return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Path$.MODULE$.apply(path), evidence$1);
    }

    private <F> OptionT<F, Path> envPath(String name, Async<F> evidence$1) {
        return this.env(name, evidence$1).map((Function1 & Serializable)_$36 -> Path$.MODULE$.apply(_$36), evidence$1);
    }

    private <F> Object checkExists(Path path, Async<F> evidence$1) {
        return package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(Files$.MODULE$.implicitForAsync(evidence$1)).exists(path), evidence$1).map((Function1 & Serializable)_$38 -> KubeConfig$.checkExists$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)_$38)));
    }

    public KubeConfig<?> fromProduct(Product x$0) {
        return new KubeConfig((Uri)x$0.productElement(0), (Option<Object>)((Option)x$0.productElement(1)), (Option<String>)((Option)x$0.productElement(2)), (Option<Path>)((Option)x$0.productElement(3)), (Option<String>)((Option)x$0.productElement(4)), (Option<Path>)((Option)x$0.productElement(5)), (Option<String>)((Option)x$0.productElement(6)), (Option<Path>)((Option)x$0.productElement(7)), (Option<String>)((Option)x$0.productElement(8)), (Option<AuthInfoExec>)((Option)x$0.productElement(9)), (Option<Function1<Object, Object>>)((Option)x$0.productElement(10)));
    }

    private static final OptionT standard$$anonfun$1(Logger evidence$1$1, Async F$2) {
        return MODULE$.findConfigInHomeDir((Option<String>)package.all$.MODULE$.none(), evidence$1$1, F$2);
    }

    private static final OptionT standard$$anonfun$2(Logger evidence$1$2, Async F$3) {
        return MODULE$.findClusterConfig(evidence$1$2, F$3);
    }

    private static final KubeConfigNotFoundError$ standard$$anonfun$3() {
        return KubeConfigNotFoundError$.MODULE$;
    }

    private static final KubeConfigNotFoundError$ fromEnv$$anonfun$1() {
        return KubeConfigNotFoundError$.MODULE$;
    }

    private static final KubeConfigNotFoundError$ inHomeDir$$anonfun$1() {
        return KubeConfigNotFoundError$.MODULE$;
    }

    private static final KubeConfigNotFoundError$ inHomeDir$$anonfun$2() {
        return KubeConfigNotFoundError$.MODULE$;
    }

    private static final KubeConfigNotFoundError$ cluster$$anonfun$1() {
        return KubeConfigNotFoundError$.MODULE$;
    }

    private static final void $anonfun$4$$anonfun$1() {
    }

    private static final NonEmptyList $anonfun$4$$anonfun$2(String error$1) {
        return NonEmptyList$.MODULE$.one((Object)error$1);
    }

    private static final String findFromEnv$$anonfun$2$$anonfun$1() {
        return EnvKubeConfig + " is not defined, or path does not exist";
    }

    private static final Object findFromEnv$$anonfun$2(Logger evidence$1$3) {
        return Logger$.MODULE$.apply(evidence$1$3).debug(KubeConfig$::findFromEnv$$anonfun$2$$anonfun$1);
    }

    private static final String findFromEnv$$anonfun$3$$anonfun$1(Path path$1) {
        return "using configuration specified by " + EnvKubeConfig + "=" + path$1;
    }

    private static final String findConfigInHomeDir$$anonfun$3$$anonfun$1() {
        return "~/" + KubeConfigDir + "/" + KubeConfigFile + " does not exist";
    }

    private static final Object findConfigInHomeDir$$anonfun$3(Logger evidence$1$6) {
        return Logger$.MODULE$.apply(evidence$1$6).debug(KubeConfig$::findConfigInHomeDir$$anonfun$3$$anonfun$1);
    }

    private static final String findConfigInHomeDir$$anonfun$4$$anonfun$1(Path path$2) {
        return "using configuration specified in " + path$2;
    }

    private static final Object findConfigInHomeDir$$anonfun$5$$anonfun$1(Path path$3, Async F$8, Logger evidence$1$9) {
        return MODULE$.fromFile(path$3, F$8, evidence$1$9);
    }

    private static final String findClusterConfig$$anonfun$2$$anonfun$1() {
        return ServiceAccountTokenPath + " does not exist";
    }

    private static final Object findClusterConfig$$anonfun$2(Logger evidence$1$11) {
        return Logger$.MODULE$.apply(evidence$1$11).debug(KubeConfig$::findClusterConfig$$anonfun$2$$anonfun$1);
    }

    private static final String findClusterConfig$$anonfun$4$$anonfun$1() {
        return ServiceAccountCAPath + " does not exist";
    }

    private static final Object findClusterConfig$$anonfun$4(Logger evidence$1$12) {
        return Logger$.MODULE$.apply(evidence$1$12).debug(KubeConfig$::findClusterConfig$$anonfun$4$$anonfun$1);
    }

    private static final String findClusterConfig$$anonfun$7$$anonfun$1() {
        return EnvServiceHost + " is not defined, or not a valid IP address";
    }

    private static final Object findClusterConfig$$anonfun$7(Logger evidence$1$13) {
        return Logger$.MODULE$.apply(evidence$1$13).debug(KubeConfig$::findClusterConfig$$anonfun$7$$anonfun$1);
    }

    private static final String findClusterConfig$$anonfun$9$$anonfun$1() {
        return EnvServicePort + " is not defined, or not a valid port number";
    }

    private static final Object findClusterConfig$$anonfun$9(Logger evidence$1$14) {
        return Logger$.MODULE$.apply(evidence$1$14).debug(KubeConfig$::findClusterConfig$$anonfun$9$$anonfun$1);
    }

    private static final String findClusterConfig$$anonfun$10$$anonfun$1(Uri.Host serviceHost$1, Port servicePort$1, Path tokenPath$1, Path caPath$1) {
        return "using the in-cluster configuration: " + EnvServiceHost + "=" + serviceHost$1 + ", " + EnvServicePort + "=" + servicePort$1 + ", " + ServiceAccountTokenPath + "=" + tokenPath$1 + ", " + ServiceAccountCAPath + "=" + caPath$1;
    }

    private static final String findHomeDir$$anonfun$1() {
        return "finding the home directory";
    }

    private static final String findHomeDir$$anonfun$2$$anonfun$2$$anonfun$1() {
        return EnvHome + " is not defined, or path does not exist";
    }

    private static final Object findHomeDir$$anonfun$2$$anonfun$2(Logger evidence$1$17) {
        return Logger$.MODULE$.apply(evidence$1$17).debug(KubeConfig$::findHomeDir$$anonfun$2$$anonfun$2$$anonfun$1);
    }

    private static final String findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1() {
        return EnvHomeDrive + " and/or " + EnvHomePath + " is/are not defined, or path does not exist";
    }

    private static final Object findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$3(Logger evidence$1$20) {
        return Logger$.MODULE$.apply(evidence$1$20).debug(KubeConfig$::findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1);
    }

    private static final String findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1() {
        return EnvUserProfile + " is not defined, or path does not exist";
    }

    private static final Object findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4$$anonfun$2(Logger evidence$1$22) {
        return Logger$.MODULE$.apply(evidence$1$22).debug(KubeConfig$::findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1);
    }

    private static final OptionT findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4(Async F$18, Logger evidence$1$21) {
        return MODULE$.envPath(EnvUserProfile, F$18).flatMapF((Function1 & Serializable)_$29 -> MODULE$.checkExists((Path)_$29, (Async)F$18), (Monad)F$18).flatTapNone(() -> KubeConfig$.findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4$$anonfun$2(evidence$1$21), (Monad)F$18);
    }

    private static final OptionT findHomeDir$$anonfun$2$$anonfun$3(Async F$15, Logger evidence$1$18) {
        return MODULE$.sysProp("os.name", F$15).filter((Function1 & Serializable)_$26 -> _$26.toLowerCase().startsWith("windows"), (Functor)F$15).flatMap((Function1 & Serializable)_$27 -> ((OptionT)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(MODULE$.env(EnvHomeDrive, F$15), MODULE$.envPath(EnvHomePath, F$15))).tupled((Invariant)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F$15), (Semigroupal)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F$15))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String homeDrive = (String)tuple2._1();
                Path homePath = (Path)tuple2._2();
                return Path$.MODULE$.apply(homeDrive).resolve(homePath);
            }
            throw new MatchError((Object)tuple2);
        }, (Functor)F$15).flatMapF((Function1 & Serializable)_$28 -> MODULE$.checkExists((Path)_$28, (Async)F$15), (Monad)F$15).flatTapNone(() -> KubeConfig$.findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$3(evidence$1$18), (Monad)F$15).orElse(() -> KubeConfig$.findHomeDir$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4(F$15, evidence$1$18), (Monad)F$15), (Monad)F$15);
    }

    private static final OptionT findHomeDir$$anonfun$2(Async F$13, Logger evidence$1$16) {
        return MODULE$.envPath(EnvHome, F$13).flatMapF((Function1 & Serializable)_$25 -> MODULE$.checkExists((Path)_$25, (Async)F$13), (Monad)F$13).flatTapNone(() -> KubeConfig$.findHomeDir$$anonfun$2$$anonfun$2(evidence$1$16), (Monad)F$13).orElse(() -> KubeConfig$.findHomeDir$$anonfun$2$$anonfun$3(F$13, evidence$1$16), (Monad)F$13);
    }

    private static final Option sysProp$$anonfun$1(String name$1) {
        return Option$.MODULE$.apply((Object)System.getProperty(name$1)).filterNot((Function1 & Serializable)_$31 -> _$31.isEmpty());
    }

    private static final Option env$$anonfun$1(String name$2) {
        return Option$.MODULE$.apply((Object)System.getenv(name$2)).filterNot((Function1 & Serializable)_$33 -> _$33.isEmpty());
    }

    private static final /* synthetic */ Option checkExists$$anonfun$1(Path path$5, boolean _$38) {
        if (_$38) {
            return Option$.MODULE$.apply((Object)path$5);
        }
        return package.all$.MODULE$.none();
    }
}

