/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.api;

import cats.effect.kernel.Async;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.crd.CrdContext;
import com.goyeau.kubernetes.client.crd.CustomResource;
import com.goyeau.kubernetes.client.crd.CustomResourceList;
import com.goyeau.kubernetes.client.operation.Creatable;
import com.goyeau.kubernetes.client.operation.Deletable;
import com.goyeau.kubernetes.client.operation.Gettable;
import com.goyeau.kubernetes.client.operation.GroupDeletable;
import com.goyeau.kubernetes.client.operation.Listable;
import com.goyeau.kubernetes.client.operation.Replaceable;
import com.goyeau.kubernetes.client.operation.Watchable;
import com.goyeau.kubernetes.client.operation.package$;
import com.goyeau.kubernetes.client.util.CirceEntityCodec$;
import io.circe.Decoder;
import io.circe.Encoder;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.typelevel.jawn.Facade;
import scala.Option;
import scala.runtime.Statics;

public class NamespacedCustomResourcesApi<F, A, B>
implements Creatable<F, CustomResource<A, B>>,
Replaceable<F, CustomResource<A, B>>,
Gettable<F, CustomResource<A, B>>,
Listable<F, CustomResourceList<A, B>>,
Deletable<F>,
GroupDeletable<F>,
Watchable<F, CustomResource<A, B>> {
    private Facade parserFacade;
    private final Client httpClient;
    private final KubeConfig config;
    private final Option authorization;
    private final CrdContext context;
    private final Async F;
    private final Encoder resourceEncoder;
    private final Decoder resourceDecoder;
    private final Decoder listDecoder;
    private final Uri resourceUri;

    public NamespacedCustomResourcesApi(Client<F> httpClient, KubeConfig<F> config, Option<Object> authorization, CrdContext context, String namespace, Async<F> F, Encoder<CustomResource<A, B>> resourceEncoder, Decoder<CustomResource<A, B>> resourceDecoder, Decoder<CustomResourceList<A, B>> listDecoder) {
        this.httpClient = httpClient;
        this.config = config;
        this.authorization = authorization;
        this.context = context;
        this.F = F;
        this.resourceEncoder = resourceEncoder;
        this.resourceDecoder = resourceDecoder;
        this.listDecoder = listDecoder;
        Watchable.$init$(this);
        this.resourceUri = Uri$.MODULE$.unsafeFromString("/apis").$div(context.group()).$div(context.version()).$div("namespaces").$div(namespace).$div(context.plural());
        Statics.releaseFence();
    }

    @Override
    public Facade parserFacade() {
        return this.parserFacade;
    }

    @Override
    public void com$goyeau$kubernetes$client$operation$Watchable$_setter_$parserFacade_$eq(Facade x$0) {
        this.parserFacade = x$0;
    }

    @Override
    public Client<F> httpClient() {
        return this.httpClient;
    }

    @Override
    public KubeConfig<F> config() {
        return this.config;
    }

    @Override
    public Option<F> authorization() {
        return this.authorization;
    }

    public CrdContext context() {
        return this.context;
    }

    @Override
    public Async<F> F() {
        return this.F;
    }

    @Override
    public Encoder<CustomResource<A, B>> resourceEncoder() {
        return this.resourceEncoder;
    }

    @Override
    public Decoder<CustomResource<A, B>> resourceDecoder() {
        return this.resourceDecoder;
    }

    @Override
    public Decoder<CustomResourceList<A, B>> listDecoder() {
        return this.listDecoder;
    }

    @Override
    public Uri resourceUri() {
        return this.resourceUri;
    }

    public F updateStatus(String name, CustomResource<A, B> resource) {
        return (F)this.httpClient().status(package$.MODULE$.KubernetesRequestOps((Request)Request$.MODULE$.apply(Method$.MODULE$.PUT(), this.config().server().resolve(this.resourceUri().$div(name).$div("status")), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withEntity(resource, CirceEntityCodec$.MODULE$.circeEntityEncoder(this.resourceEncoder())), this.F()).withOptionalAuthorization(this.authorization()));
    }
}

