/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.util;

import com.goyeau.kubernetes.client.KubeConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class SslContexts$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SslContexts$.class.getDeclaredField("defaultTrustStore$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SslContexts$.class.getDeclaredField("defaultKeyStore$lzy1"));
    private static final String TrustStoreSystemProperty;
    private static String TrustStorePasswordSystemProperty;
    private static final String KeyStoreSystemProperty;
    private static String KeyStorePasswordSystemProperty;
    private volatile Object defaultKeyStore$lzy1;
    private volatile Object defaultTrustStore$lzy1;
    public static final SslContexts$ MODULE$;

    private SslContexts$() {
    }

    static {
        MODULE$ = new SslContexts$();
        TrustStoreSystemProperty = "javax.net.ssl.trustStore";
        TrustStorePasswordSystemProperty = "javax.net.ssl.trustStorePassword";
        KeyStoreSystemProperty = "javax.net.ssl.keyStore";
        KeyStorePasswordSystemProperty = "javax.net.ssl.keyStorePassword";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SslContexts$.class);
    }

    public <F> SSLContext fromConfig(KubeConfig<F> config) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers(config), this.trustManagers(config), new SecureRandom());
        return sslContext;
    }

    private <F> KeyManager[] keyManagers(KubeConfig<F> config) {
        Option certDataStream = config.clientCertData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = config.clientCertFile().map((Function1 & Serializable)_$3 -> _$3.toNioPath().toFile()).map((Function1 & Serializable)_$4 -> new FileInputStream((File)_$4));
        Option keyDataStream = config.clientKeyData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option keyFileStream = config.clientKeyFile().map((Function1 & Serializable)_$5 -> _$5.toNioPath().toFile()).map((Function1 & Serializable)_$6 -> new FileInputStream((File)_$6));
        Option option = keyDataStream.orElse(() -> SslContexts$.keyManagers$$anonfun$1(keyFileStream)).flatMap((Function1 & Serializable)keyStream -> certDataStream.orElse(() -> SslContexts$.keyManagers$$anonfun$2$$anonfun$1(certFileStream)).map((Function1)(JProcedure1 & Serializable)certStream -> {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMKeyPair pemKeyPair = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader((InputStream)keyStream)).readObject();
            PrivateKey privateKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pemKeyPair.getPrivateKeyInfo());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)certStream);
            MODULE$.defaultKeyStore().setKeyEntry(certificate.getSubjectX500Principal().getName(), privateKey, (char[])config.clientKeyPass().fold(SslContexts$::keyManagers$$anonfun$2$$anonfun$2$$anonfun$1, (Function1 & Serializable)_$7 -> _$7.toCharArray()), new Certificate[]{certificate});
        }));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.defaultKeyStore(), (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE)));
        return keyManagerFactory.getKeyManagers();
    }

    private KeyStore defaultKeyStore() {
        Object object = this.defaultKeyStore$lzy1;
        if (object instanceof KeyStore) {
            return (KeyStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (KeyStore)this.defaultKeyStore$lzyINIT1();
    }

    private Object defaultKeyStore$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.defaultKeyStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    KeyStore keyStore = null;
                    try {
                        Option propertyKeyStoreFile = Option$.MODULE$.apply((Object)System.getProperty(KeyStoreSystemProperty, "")).filter((Function1 & Serializable)_$8 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$8))).map((Function1 & Serializable)_$9 -> new File((String)_$9));
                        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore2.load((InputStream)propertyKeyStoreFile.map((Function1 & Serializable)_$10 -> new FileInputStream((File)_$10)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), System.getProperty(KeyStorePasswordSystemProperty, "").toCharArray());
                        keyStore = keyStore2;
                        object2 = keyStore == null ? LazyVals.NullValue$.MODULE$ : keyStore;
                        KeyStorePasswordSystemProperty = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultKeyStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultKeyStore$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return keyStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private <F> TrustManager[] trustManagers(KubeConfig<F> config) {
        Option certDataStream = config.caCertData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = config.caCertFile().map((Function1 & Serializable)_$12 -> _$12.toNioPath().toFile()).map((Function1 & Serializable)_$13 -> new FileInputStream((File)_$13));
        certDataStream.orElse(() -> SslContexts$.trustManagers$$anonfun$1(certFileStream)).foreach((Function1)(JProcedure1 & Serializable)certStream -> {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            Iterable certificates = CollectionConverters$.MODULE$.CollectionHasAsScala(certificateFactory.generateCertificates((InputStream)certStream)).asScala();
            ((IterableOnceOps)((IterableOps)certificates.map((Function1 & Serializable)_$14 -> (X509Certificate)_$14)).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    X509Certificate certificate = (X509Certificate)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    String alias = certificate.getSubjectX500Principal().getName() + "-" + i;
                    MODULE$.defaultTrustStore().setCertificateEntry(alias, certificate);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        });
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.defaultTrustStore());
        return trustManagerFactory.getTrustManagers();
    }

    private KeyStore defaultTrustStore() {
        Object object = this.defaultTrustStore$lzy1;
        if (object instanceof KeyStore) {
            return (KeyStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (KeyStore)this.defaultTrustStore$lzyINIT1();
    }

    private Object defaultTrustStore$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.defaultTrustStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    KeyStore keyStore = null;
                    try {
                        String securityDirectory = System.getProperty("java.home") + "/lib/security";
                        Option propertyTrustStoreFile = Option$.MODULE$.apply((Object)System.getProperty(TrustStoreSystemProperty, "")).filter((Function1 & Serializable)_$15 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$15))).map((Function1 & Serializable)_$16 -> new File((String)_$16));
                        Option jssecacertsFile = Option$.MODULE$.apply((Object)new File(securityDirectory + "/jssecacerts")).filter((Function1 & Serializable)f -> f.exists() && f.isFile());
                        File cacertsFile = new File(securityDirectory + "/cacerts");
                        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore2.load(new FileInputStream((File)propertyTrustStoreFile.orElse(() -> SslContexts$.defaultTrustStore$lzyINIT1$$anonfun$1(jssecacertsFile)).getOrElse(() -> SslContexts$.defaultTrustStore$lzyINIT1$$anonfun$2(cacertsFile))), System.getProperty(TrustStorePasswordSystemProperty, "changeit").toCharArray());
                        keyStore = keyStore2;
                        object2 = keyStore == null ? LazyVals.NullValue$.MODULE$ : keyStore;
                        TrustStorePasswordSystemProperty = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultTrustStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultTrustStore$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return keyStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Option keyManagers$$anonfun$1(Option keyFileStream$1) {
        return keyFileStream$1;
    }

    private static final Option keyManagers$$anonfun$2$$anonfun$1(Option certFileStream$2) {
        return certFileStream$2;
    }

    private static final char[] keyManagers$$anonfun$2$$anonfun$2$$anonfun$1() {
        return (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE));
    }

    private static final Option trustManagers$$anonfun$1(Option certFileStream$3) {
        return certFileStream$3;
    }

    private static final Option defaultTrustStore$lzyINIT1$$anonfun$1(Option jssecacertsFile$1) {
        return jssecacertsFile$1;
    }

    private static final File defaultTrustStore$lzyINIT1$$anonfun$2(File cacertsFile$1) {
        return cacertsFile$1;
    }
}

