/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.api;

import cats.ApplicativeError;
import cats.Apply;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.api.ExecRouting$;
import com.goyeau.kubernetes.client.api.ExecStream;
import com.goyeau.kubernetes.client.api.ExecStream$StdErr$;
import com.goyeau.kubernetes.client.api.ExecStream$StdOut$;
import com.goyeau.kubernetes.client.api.ParseFailure;
import com.goyeau.kubernetes.client.api.ParseFailure$;
import com.goyeau.kubernetes.client.operation.Creatable;
import com.goyeau.kubernetes.client.operation.Deletable;
import com.goyeau.kubernetes.client.operation.DeletableTerminated;
import com.goyeau.kubernetes.client.operation.Gettable;
import com.goyeau.kubernetes.client.operation.GroupDeletable;
import com.goyeau.kubernetes.client.operation.Listable;
import com.goyeau.kubernetes.client.operation.Proxy;
import com.goyeau.kubernetes.client.operation.Replaceable;
import com.goyeau.kubernetes.client.operation.Watchable;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Signal;
import fs2.concurrent.SignallingRef;
import fs2.concurrent.SignallingRef$;
import fs2.io.file.Files$;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Error;
import io.k8s.api.core.v1.Pod;
import io.k8s.api.core.v1.PodList;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status$;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import org.http4s.Charset$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method$;
import org.http4s.QueryParamEncoder$;
import org.http4s.QueryParamKeyLike$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.headers.Authorization$;
import org.http4s.jdkhttpclient.WSClient;
import org.http4s.jdkhttpclient.WSConnectionHighLevel;
import org.http4s.jdkhttpclient.WSDataFrame;
import org.http4s.jdkhttpclient.WSFrame;
import org.http4s.jdkhttpclient.WSRequest;
import org.http4s.jdkhttpclient.WSRequest$;
import org.typelevel.ci.CIString$;
import org.typelevel.jawn.Facade;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class NamespacedPodsApi<F>
implements Creatable<F, Pod>,
Replaceable<F, Pod>,
Gettable<F, Pod>,
Listable<F, PodList>,
Proxy<F>,
Deletable<F>,
DeletableTerminated<F>,
GroupDeletable<F>,
Watchable<F, Pod> {
    private Facade parserFacade;
    private final Client httpClient;
    private final WSClient<F> wsClient;
    private final KubeConfig config;
    private final Async F;
    private final Encoder resourceEncoder;
    private final Decoder resourceDecoder;
    private final Decoder listDecoder;
    private final Logger logger;
    private final Uri resourceUri;
    private final List execHeaders;
    private final Uri webSocketAddress;

    public <F> NamespacedPodsApi(Client<F> httpClient, WSClient<F> wsClient, KubeConfig config, String namespace, Async<F> F2, Encoder<Pod> resourceEncoder, Decoder<Pod> resourceDecoder, Decoder<PodList> listDecoder, Logger<F> logger) {
        this.httpClient = httpClient;
        this.wsClient = wsClient;
        this.config = config;
        this.F = F2;
        this.resourceEncoder = resourceEncoder;
        this.resourceDecoder = resourceDecoder;
        this.listDecoder = listDecoder;
        this.logger = logger;
        Watchable.$init$(this);
        ArraySeq args$proxy2 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]);
        this.resourceUri = Uri$.MODULE$.unsafeFromString("/api").$div("v1").$div("namespaces").$div(namespace).$div("pods");
        this.execHeaders = Headers$.MODULE$.put$extension(Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)config.authorization().toList(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, Authorization$.MODULE$.headerInstance()))})), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply("Sec-WebSocket-Protocol"), "v4.channel.k8s.io"))}));
        this.webSocketAddress = Uri$.MODULE$.unsafeFromString(config.server().toString().replaceFirst("http", "ws"));
        Statics.releaseFence();
    }

    @Override
    public Facade parserFacade() {
        return this.parserFacade;
    }

    @Override
    public void com$goyeau$kubernetes$client$operation$Watchable$_setter_$parserFacade_$eq(Facade x$0) {
        this.parserFacade = x$0;
    }

    @Override
    public Client<F> httpClient() {
        return this.httpClient;
    }

    @Override
    public KubeConfig config() {
        return this.config;
    }

    @Override
    public Async<F> F() {
        return this.F;
    }

    @Override
    public Encoder<Pod> resourceEncoder() {
        return this.resourceEncoder;
    }

    @Override
    public Decoder<Pod> resourceDecoder() {
        return this.resourceDecoder;
    }

    @Override
    public Decoder<PodList> listDecoder() {
        return this.listDecoder;
    }

    public Logger<F> logger() {
        return this.logger;
    }

    @Override
    public Uri resourceUri() {
        return this.resourceUri;
    }

    public List execHeaders() {
        return this.execHeaders;
    }

    public Uri webSocketAddress() {
        return this.webSocketAddress;
    }

    private WSRequest execRequest(String podName, scala.collection.immutable.Seq<String> commands, Option<String> container, boolean stdin, boolean stdout, boolean stderr, boolean tty) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"stdin");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stdout");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stderr");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tty");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"container");
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"command");
        Uri uri = (Uri)this.webSocketAddress().resolve(this.resourceUri()).$div(podName).$div("exec").$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)stdin).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToBoolean((boolean)stdout).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)stderr).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BoxesRunTime.boxToBoolean((boolean)tty).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, container), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, commands), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder());
        return WSRequest$.MODULE$.apply(uri, this.execHeaders(), Method$.MODULE$.POST());
    }

    private boolean execRequest$default$4() {
        return false;
    }

    private boolean execRequest$default$5() {
        return true;
    }

    private boolean execRequest$default$6() {
        return true;
    }

    private boolean execRequest$default$7() {
        return false;
    }

    public F downloadFile(String podName, Path sourceFile, Path destinationFile, Option<String> container) {
        WSRequest request = this.execRequest(podName, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sh", "-c", "cat " + sourceFile.toString()}))), container, this.execRequest$default$4(), this.execRequest$default$5(), this.execRequest$default$6(), this.execRequest$default$7());
        Resource destination = package$.MODULE$.Resource().make(this.F().delay(() -> NamespacedPodsApi.$anonfun$1(destinationFile)), (Function1 & Serializable)s -> this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> NamespacedPodsApi.$anonfun$6$$anonfun$1(s))), this.F());
        return (F)destination.use((Function1 & Serializable)destFile -> this.wsClient.connectHighLevel(request).use((Function1 & Serializable)connection -> connection.receiveStream().through(this.processWebSocketData()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).fold((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.List().empty(), (Object)package.all$.MODULE$.none()), (arg_0, arg_1) -> NamespacedPodsApi.downloadFile$$anonfun$2$$anonfun$1$$anonfun$1(destFile, arg_0, arg_1)), this.F()), this.F());
    }

    public Option<String> downloadFile$default$4() {
        return None$.MODULE$;
    }

    public F uploadFile(String podName, Path sourceFile, Path destinationFile, Option<String> container) {
        Object object;
        Option destinationDir = Option$.MODULE$.apply((Object)destinationFile.getParent());
        Option option = destinationDir;
        if (option instanceof Some) {
            Path dir = (Path)((Some)option).value();
            WSRequest mkDirRequest = this.execRequest(podName, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sh", "-c", "mkdir -p " + dir}))), container, this.execRequest$default$4(), this.execRequest$default$5(), this.execRequest$default$6(), this.execRequest$default$7());
            object = this.wsClient.connectHighLevel(mkDirRequest).map((Function1 & Serializable)conn -> this.F().delay(() -> this.$anonfun$8$$anonfun$1(conn))).use((Function1 & Serializable)_$3 -> package.all$.MODULE$.toFlatMapOps(_$3, this.F()).flatMap((Function1 & Serializable)stdoutStream -> this.foldErrorStream((Stream<F, Either<ExecStream, Either<ParseFailure, Status>>>)stdoutStream)), this.F());
        } else if (None$.MODULE$.equals(option)) {
            List list = (List)Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.List().empty());
            Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)None$.MODULE$));
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)tuple2, this.F());
        } else {
            throw new MatchError((Object)option);
        }
        Object mkDirResult = object;
        WSRequest uploadRequest = this.execRequest(podName, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sh", "-c", "cat - >" + destinationFile}))), container, true, this.execRequest$default$5(), this.execRequest$default$6(), this.execRequest$default$7());
        Object uploadFileResult = this.wsClient.connectHighLevel(uploadRequest).use((Function1 & Serializable)connection -> {
            Stream source = Files$.MODULE$.apply(Files$.MODULE$.forAsync(this.F())).readAll(sourceFile, 4096);
            Stream sendData = source.mapChunks((Function1 & Serializable)chunk -> Chunk$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WSFrame.Binary[]{WSFrame.Binary$.MODULE$.apply(ByteVector$.MODULE$.apply(chunk.toChain().prepend((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdInId())).toVector()), WSFrame.Binary$.MODULE$.$lessinit$greater$default$2())}))).through(connection.sendPipe());
            int retryAttempts = 5;
            Stream stream = (Stream)package.all$.MODULE$.catsSyntaxApplicativeError((Object)Stream$.MODULE$.retry(sendData.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).drain(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(500)).millis(), (Function1 & Serializable)_$4 -> _$4.$times(2L), retryAttempts, Stream$.MODULE$.retry$default$5(), this.F(), RaiseThrowable$.MODULE$.fromApplicativeError(this.F())), (ApplicativeError)Stream$.MODULE$.monadErrorInstance(this.F()));
            Stream sendWithRetry = (Stream)ApplicativeErrorOps$.MODULE$.onError$extension((Object)stream, (PartialFunction)new Serializable(retryAttempts, this){
                private final int retryAttempts$1;
                private final NamespacedPodsApi $outer;
                {
                    this.retryAttempts$1 = retryAttempts$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return Stream$.MODULE$.eval(Logger$.MODULE$.apply(this.$outer.logger()).error(e, this::applyOrElse$$anonfun$1));
                }

                private final String applyOrElse$$anonfun$1() {
                    return "Failed send file data after " + this.retryAttempts$1 + " attempts";
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
                }
            }, (ApplicativeError)Stream$.MODULE$.monadErrorInstance(this.F()));
            Stream result = Stream$.MODULE$.eval(SignallingRef$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), this.F())).map((Function1 & Serializable)signal -> {
                Stream dataStream = (Stream)package.all$.MODULE$.catsSyntaxApply((Object)sendWithRetry, (Apply)Stream$.MODULE$.monadErrorInstance(this.F())).$times$greater((Object)Stream$.MODULE$.eval(signal.set((Object)BoxesRunTime.boxToBoolean((boolean)true))));
                Stream output = connection.receiveStream().through(this.processWebSocketData()).interruptWhen((Signal)signal, this.F()).concurrently(dataStream, this.F());
                Object errors = package.all$.MODULE$.toFunctorOps(this.foldErrorStream(output), this.F()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    List errors = (List)tuple2._1();
                    return errors;
                });
                return Tuple4$.MODULE$.apply(signal, (Object)dataStream, (Object)output, errors);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple4 tuple4 = x$1;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                SignallingRef signal = (SignallingRef)tuple4._1();
                Stream dataStream = (Stream)tuple4._2();
                Stream output = (Stream)tuple4._3();
                Object errors = tuple4._4();
                return errors;
            });
            Object object = package.all$.MODULE$.catsSyntaxFlatten(result.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).lastOrError(this.F()), this.F());
            return FlattenOps$.MODULE$.flatten$extension(object, this.F());
        }, this.F());
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(mkDirResult, this.F()).map((Function1 & Serializable)result -> {
            Tuple2 tuple2 = result;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List errors = (List)tuple2._1();
            Option status = (Option)tuple2._2();
            Tuple2 $2$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$2$, (Object)errors, (Object)status);
            Tuple2 $2$2 = (Tuple2)tuple3._1();
            List errors2 = (List)tuple3._2();
            Option status2 = (Option)tuple3._3();
            return Tuple2$.MODULE$.apply(result, (Object)$2$2);
        }), this.F()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._2();
                    Tuple2 result = (Tuple2)tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            List errors = (List)tuple2._1();
            Option status = (Option)tuple2._2();
            return package.all$.MODULE$.toFunctorOps(uploadFileResult, this.F()).map((Function1 & Serializable)uploadErrors -> Tuple2$.MODULE$.apply(errors.$plus$plus((IterableOnce)uploadErrors), (Object)status));
        });
    }

    public Option<String> uploadFile$default$4() {
        return None$.MODULE$;
    }

    public Resource<F, F> execStream(String podName, Option<String> container, scala.collection.immutable.Seq<String> command, boolean stdin, boolean stdout, boolean stderr, boolean tty) {
        WSRequest request = this.execRequest(podName, command, container, stdin, stdout, stderr, tty);
        return this.wsClient.connectHighLevel(request).map((Function1 & Serializable)connection -> this.F().delay(() -> this.execStream$$anonfun$2$$anonfun$1(connection)));
    }

    public Option<String> execStream$default$2() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<String> execStream$default$3() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    public boolean execStream$default$4() {
        return false;
    }

    public boolean execStream$default$5() {
        return true;
    }

    public boolean execStream$default$6() {
        return true;
    }

    public boolean execStream$default$7() {
        return false;
    }

    public F exec(String podName, Option<String> container, scala.collection.immutable.Seq<String> command, boolean stdin, boolean stdout, boolean stderr, boolean tty) {
        return (F)this.execStream(podName, container, command, stdin, stdout, stderr, tty).use((Function1 & Serializable)_$5 -> package.all$.MODULE$.toFlatMapOps(_$5, this.F()).flatMap((Function1 & Serializable)stdoutStream -> this.foldStream((Stream<F, Either<ExecStream, Either<ParseFailure, Status>>>)stdoutStream)), this.F());
    }

    public Option<String> exec$default$2() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<String> exec$default$3() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    public boolean exec$default$4() {
        return false;
    }

    public boolean exec$default$5() {
        return true;
    }

    public boolean exec$default$6() {
        return true;
    }

    public boolean exec$default$7() {
        return false;
    }

    private F foldStream(Stream<F, Either<ExecStream, Either<ParseFailure, Status>>> stdoutStream) {
        return (F)stdoutStream.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).fold((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.List().empty(), (Object)package.all$.MODULE$.none()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Tuple2 tuple23 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple23 == null || (tuple22 = (Tuple2)tuple23._1()) == null) throw new MatchError((Object)tuple23);
            List accEvents = (List)tuple22._1();
            Option accStatus = (Option)tuple22._2();
            Either data = (Either)tuple23._2();
            Either either = data;
            if (either instanceof Left) {
                ExecStream event = (ExecStream)((Left)either).value();
                List list = (List)Predef$.MODULE$.ArrowAssoc(accEvents.$colon$plus((Object)event));
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus);
                return tuple2;
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                Either errorOrStatus = (Either)((Right)either).value();
                List list = (List)Predef$.MODULE$.ArrowAssoc((Object)accEvents);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus.orElse(() -> NamespacedPodsApi.foldStream$$anonfun$2$$anonfun$1(errorOrStatus)));
            }
            return tuple2;
        });
    }

    private F foldErrorStream(Stream<F, Either<ExecStream, Either<ParseFailure, Status>>> stdoutStream) {
        return (F)stdoutStream.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).fold((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.List().empty(), (Object)package.all$.MODULE$.none()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Tuple2 tuple23 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple23 == null || (tuple22 = (Tuple2)tuple23._1()) == null) throw new MatchError((Object)tuple23);
            List accEvents = (List)tuple22._1();
            Option accStatus = (Option)tuple22._2();
            Either data = (Either)tuple23._2();
            Either either = data;
            if (either instanceof Left) {
                Option option;
                ExecStream event = (ExecStream)((Left)either).value();
                ExecStream execStream = event;
                if (execStream instanceof ExecStream.StdErr) {
                    ExecStream.StdErr e = (ExecStream.StdErr)execStream;
                    ExecStream.StdErr stdErr = (ExecStream.StdErr)package.all$.MODULE$.catsSyntaxOptionId((Object)e);
                    option = OptionIdOps$.MODULE$.some$extension((Object)stdErr);
                } else {
                    option = package.all$.MODULE$.none();
                }
                List list = (List)Predef$.MODULE$.ArrowAssoc(accEvents.$plus$plus((IterableOnce)option.toList()));
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus);
                return tuple2;
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                Either errorOrStatus = (Either)((Right)either).value();
                List list = (List)Predef$.MODULE$.ArrowAssoc((Object)accEvents);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus.orElse(() -> NamespacedPodsApi.foldErrorStream$$anonfun$2$$anonfun$1(errorOrStatus)));
            }
            return tuple2;
        });
    }

    private Function1<Stream<F, WSDataFrame>, Stream<F, Either<ExecStream, Either<ParseFailure, Status>>>> processWebSocketData() {
        return (Function1 & Serializable)_$6 -> _$6.collect((PartialFunction)new Serializable(this){
            private final NamespacedPodsApi $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(WSDataFrame x) {
                WSDataFrame wSDataFrame = x;
                if (!(wSDataFrame instanceof WSFrame.Binary)) return false;
                WSFrame.Binary binary = WSFrame.Binary$.MODULE$.unapply((WSFrame.Binary)wSDataFrame);
                ByteVector byteVector = binary._1();
                boolean bl = binary._2();
                ByteVector data = byteVector;
                if (data.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdOutId()))) {
                    return true;
                }
                ByteVector data2 = byteVector;
                if (data2.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdErrId()))) {
                    return true;
                }
                ByteVector data3 = byteVector;
                if (!data3.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StatusId()))) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(WSDataFrame x, Function1 function1) {
                Object object;
                WSDataFrame wSDataFrame = x;
                if (wSDataFrame instanceof WSFrame.Binary) {
                    WSFrame.Binary binary = WSFrame.Binary$.MODULE$.unapply((WSFrame.Binary)wSDataFrame);
                    ByteVector byteVector = binary._1();
                    boolean bl = binary._2();
                    ByteVector data = byteVector;
                    if (data.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdOutId()))) {
                        ExecStream.StdOut stdOut = (ExecStream.StdOut)package.all$.MODULE$.catsSyntaxEitherId((Object)ExecStream$StdOut$.MODULE$.apply(this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(data).toArray()));
                        object = EitherIdOps$.MODULE$.asLeft$extension((Object)stdOut);
                        return object;
                    }
                    ByteVector data2 = byteVector;
                    if (data2.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdErrId()))) {
                        ExecStream.StdErr stdErr = (ExecStream.StdErr)package.all$.MODULE$.catsSyntaxEitherId((Object)ExecStream$StdErr$.MODULE$.apply(this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(data2).toArray()));
                        object = EitherIdOps$.MODULE$.asLeft$extension((Object)stdErr);
                        return object;
                    }
                    ByteVector data3 = byteVector;
                    if (data3.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StatusId()))) {
                        String json = this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$convertToString(this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(data3));
                        Either either = package.all$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.decode(json, Status$.MODULE$.decoder()));
                        Either either2 = (Either)package.all$.MODULE$.catsSyntaxEitherId((Object)EitherOps$.MODULE$.leftFlatMap$extension(either, arg_0 -> NamespacedPodsApi.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$anon$2$$_$applyOrElse$$anonfun$1(json, arg_0)));
                        object = EitherIdOps$.MODULE$.asRight$extension((Object)either2);
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$goyeau$kubernetes$client$api$NamespacedPodsApi$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.String io.circe.Error )}, serializedLambda);
            }
        });
    }

    public ByteVector com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(ByteVector data) {
        return data.drop(1L);
    }

    public String com$goyeau$kubernetes$client$api$NamespacedPodsApi$$convertToString(ByteVector data) {
        return new String(data.toArray(), Charset$.MODULE$.UTF$minus8().nioCharset());
    }

    private static final FileOutputStream $anonfun$1(Path destinationFile$1) {
        return new FileOutputStream(destinationFile$1.toFile());
    }

    private static final void $anonfun$6$$anonfun$1(FileOutputStream s$1) {
        s$1.close();
    }

    private static final Option $anonfun$7(Either statusOrError$1) {
        Either either = (Either)package.all$.MODULE$.catsSyntaxOptionId((Object)statusOrError$1);
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ Tuple2 downloadFile$$anonfun$2$$anonfun$1$$anonfun$1(FileOutputStream destFile$2, Tuple2 x$1, Either x$2) {
        block8: {
            block7: {
                var3_3 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
                if (var3_3 == null || (var4_4 = (Tuple2)var3_3._1()) == null) break block7;
                accEvents = (List)var4_4._1();
                accStatus = (Option)var4_4._2();
                data = (Either)var3_3._2();
                var10_8 = data;
                if (!(var10_8 instanceof Left)) ** GOTO lbl-1000
                var11_9 = (ExecStream)((Left)var10_8).value();
                if (var11_9 instanceof ExecStream.StdOut) {
                    var12_10 = ExecStream$StdOut$.MODULE$.unapply((ExecStream.StdOut)var11_9);
                    data = var13_11 = var12_10._1();
                    destFile$2.write(data);
                    var15_13 = (List)Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.List().empty());
                    v0 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var15_13, (Object)package.all$.MODULE$.none());
                } else if (var11_9 instanceof ExecStream.StdErr) {
                    e = (ExecStream.StdErr)var11_9;
                    var17_15 = (List)Predef$.MODULE$.ArrowAssoc(scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecStream.StdErr[]{e})));
                    v0 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var17_15, (Object)package.all$.MODULE$.none());
                } else if (var10_8 instanceof Right) {
                    statusOrError = (Either)((Right)var10_8).value();
                    var19_17 = (List)Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.List().empty());
                    v0 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var19_17, (Object)accStatus.orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$7(scala.util.Either ), ()Lscala/Option;)((Either)statusOrError)));
                } else {
                    throw new MatchError((Object)var10_8);
                }
                var9_18 = v0;
                if (var9_18 == null) {
                    throw new MatchError((Object)var9_18);
                }
                errors = (List)var9_18._1();
                status = (Option)var9_18._2();
                break block8;
            }
            throw new MatchError((Object)var3_3);
        }
        var8_21 = Tuple2$.MODULE$.apply((Object)errors, (Object)status);
        errors = (List)var8_21._1();
        status = (Option)var8_21._2();
        return Tuple2$.MODULE$.apply(accEvents.$plus$plus((IterableOnce)errors), (Object)status);
    }

    private final Stream $anonfun$8$$anonfun$1(WSConnectionHighLevel conn$1) {
        return conn$1.receiveStream().through(this.processWebSocketData());
    }

    private final Stream execStream$$anonfun$2$$anonfun$1(WSConnectionHighLevel connection$2) {
        return connection$2.receiveStream().through(this.processWebSocketData());
    }

    private static final Option foldStream$$anonfun$2$$anonfun$1(Either errorOrStatus$1) {
        Either either = (Either)package.all$.MODULE$.catsSyntaxOptionId((Object)errorOrStatus$1);
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    private static final Option foldErrorStream$$anonfun$2$$anonfun$1(Either errorOrStatus$2) {
        Either either = (Either)package.all$.MODULE$.catsSyntaxOptionId((Object)errorOrStatus$2);
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    public static final /* synthetic */ Either com$goyeau$kubernetes$client$api$NamespacedPodsApi$$anon$2$$_$applyOrElse$$anonfun$1(String json$1, Error _$7) {
        ParseFailure parseFailure = (ParseFailure)package.all$.MODULE$.catsSyntaxEitherId((Object)ParseFailure$.MODULE$.apply(json$1));
        return EitherIdOps$.MODULE$.asLeft$extension((Object)parseFailure);
    }
}

