/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.util;

import com.goyeau.kubernetes.client.KubeConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SslContexts$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(SslContexts$.class, "0bitmap$1");
    public long 0bitmap$1;
    private static final String TrustStoreSystemProperty;
    private static String TrustStorePasswordSystemProperty;
    private static final String KeyStoreSystemProperty;
    private static String KeyStorePasswordSystemProperty;
    private static KeyStore defaultKeyStore$lzy1;
    private static KeyStore defaultTrustStore$lzy1;
    public static final SslContexts$ MODULE$;

    private SslContexts$() {
    }

    static {
        MODULE$ = new SslContexts$();
        TrustStoreSystemProperty = "javax.net.ssl.trustStore";
        TrustStorePasswordSystemProperty = "javax.net.ssl.trustStorePassword";
        KeyStoreSystemProperty = "javax.net.ssl.keyStore";
        KeyStorePasswordSystemProperty = "javax.net.ssl.keyStorePassword";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SslContexts$.class);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext fromConfig(KubeConfig config) {
        void var2_2;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers(config), this.trustManagers(config), new SecureRandom());
        return var2_2;
    }

    private KeyManager[] keyManagers(KubeConfig config) {
        Option certDataStream = config.clientCertData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = config.clientCertFile().map((Function1 & Serializable)_$1 -> new FileInputStream((File)_$1));
        Option keyDataStream = config.clientKeyData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option keyFileStream = config.clientKeyFile().map((Function1 & Serializable)_$2 -> new FileInputStream((File)_$2));
        keyDataStream.orElse(() -> this.keyManagers$$anonfun$1(keyFileStream)).flatMap((Function1 & Serializable)keyStream -> certDataStream.orElse(() -> this.keyManagers$$anonfun$3$$anonfun$1(certFileStream)).map((Function1)(JProcedure1 & Serializable)certStream -> {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMKeyPair pemKeyPair = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader((InputStream)keyStream)).readObject();
            PrivateKey privateKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pemKeyPair.getPrivateKeyInfo());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)certStream);
            this.defaultKeyStore().setKeyEntry(certificate.getSubjectX500Principal().getName(), privateKey, (char[])config.clientKeyPass().fold(this::keyManagers$$anonfun$4$$anonfun$2$$anonfun$1, (Function1 & Serializable)_$3 -> _$3.toCharArray()), new Certificate[]{certificate});
        }));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.defaultKeyStore(), (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE)));
        return keyManagerFactory.getKeyManagers();
    }

    private KeyStore defaultKeyStore() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$_m_0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$_m_0, l, 1, 0)) continue;
                try {
                    KeyStore keyStore;
                    Option propertyKeyStoreFile = Option$.MODULE$.apply((Object)System.getProperty(KeyStoreSystemProperty, "")).filter((Function1 & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$4))).map((Function1 & Serializable)_$5 -> new File((String)_$5));
                    KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore2.load((InputStream)propertyKeyStoreFile.map((Function1 & Serializable)_$6 -> new FileInputStream((File)_$6)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), System.getProperty(KeyStorePasswordSystemProperty, "").toCharArray());
                    defaultKeyStore$lzy1 = keyStore = keyStore2;
                    KeyStorePasswordSystemProperty = null;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 3, 0);
                    return keyStore;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$_m_0, l, 0);
        }
        return defaultKeyStore$lzy1;
    }

    private TrustManager[] trustManagers(KubeConfig config) {
        Option certDataStream = config.caCertData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = config.caCertFile().map((Function1 & Serializable)_$7 -> new FileInputStream((File)_$7));
        certDataStream.orElse(() -> this.trustManagers$$anonfun$1(certFileStream)).foreach((Function1)(JProcedure1 & Serializable)certStream -> {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)certStream);
            this.defaultTrustStore().setCertificateEntry(certificate.getSubjectX500Principal().getName(), certificate);
        });
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.defaultTrustStore());
        return trustManagerFactory.getTrustManagers();
    }

    private KeyStore defaultTrustStore() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$_m_0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$_m_0, l, 1, 1)) continue;
                try {
                    KeyStore keyStore;
                    String securityDirectory = "" + System.getProperty("java.home") + "/lib/security";
                    Option propertyTrustStoreFile = Option$.MODULE$.apply((Object)System.getProperty(TrustStoreSystemProperty, "")).filter((Function1 & Serializable)_$8 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$8))).map((Function1 & Serializable)_$9 -> new File((String)_$9));
                    Option jssecacertsFile = Option$.MODULE$.apply((Object)new File("" + securityDirectory + "/jssecacerts")).filter((Function1 & Serializable)f -> f.exists() && f.isFile());
                    File cacertsFile = new File("" + securityDirectory + "/cacerts");
                    KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore2.load(new FileInputStream((File)propertyTrustStoreFile.orElse(() -> this.defaultTrustStore$$anonfun$1(jssecacertsFile)).getOrElse(() -> this.defaultTrustStore$$anonfun$2(cacertsFile))), System.getProperty(TrustStorePasswordSystemProperty, "changeit").toCharArray());
                    defaultTrustStore$lzy1 = keyStore = keyStore2;
                    TrustStorePasswordSystemProperty = null;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 3, 1);
                    return keyStore;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$_m_0, l, 1);
        }
        return defaultTrustStore$lzy1;
    }

    private final Option keyManagers$$anonfun$1(Option keyFileStream$1) {
        return keyFileStream$1;
    }

    private final Option keyManagers$$anonfun$3$$anonfun$1(Option certFileStream$2) {
        return certFileStream$2;
    }

    private final char[] keyManagers$$anonfun$4$$anonfun$2$$anonfun$1() {
        return (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE));
    }

    private final Option trustManagers$$anonfun$1(Option certFileStream$3) {
        return certFileStream$3;
    }

    private final Option defaultTrustStore$$anonfun$1(Option jssecacertsFile$1) {
        return jssecacertsFile$1;
    }

    private final File defaultTrustStore$$anonfun$2(File cacertsFile$1) {
        return cacertsFile$1;
    }
}

