package io.k8s.api.core.v1

/* AttachedVolume describes a volume attached to a node */
import io.circe._
import io.circe.generic.semiauto._

case class AttachedVolume(
  /* Name of the attached volume */
  name: String,
  /* DevicePath represents the device path where the volume should be available */
  devicePath: String
)

object AttachedVolume {
  implicit lazy val encoder: Encoder.AsObject[AttachedVolume] = deriveEncoder
  implicit lazy val decoder: Decoder[AttachedVolume] = deriveDecoder
}
