package io.k8s.api.core.v1

/* AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. */
import io.circe._
import io.circe.generic.semiauto._

case class AzureDiskVolumeSource(
  /* The Name of the data disk in the blob storage */
  diskName: String,
  /* The URI the data disk in the blob storage */
  diskURI: String,
  /* Host Caching mode: None, Read Only, Read Write. */
  cachingMode: Option[String] = None,
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. */
  fsType: Option[String] = None,
  /* Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared */
  kind: Option[String] = None,
  /* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None
)

object AzureDiskVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[AzureDiskVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[AzureDiskVolumeSource] = deriveDecoder
}
