package io.k8s.api.storage.v1beta1

/* CSINodeSpec holds information about the specification of all CSI drivers installed on a node */
import io.circe._
import io.circe.generic.semiauto._

case class CSINodeSpec(
  /* drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty. */
  drivers: Seq[io.k8s.api.storage.v1beta1.CSINodeDriver]
)

object CSINodeSpec {
  implicit lazy val encoder: Encoder.AsObject[CSINodeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[CSINodeSpec] = deriveDecoder
}
