package io.k8s.api.core.v1

/* Represents a source location of a volume to mount, managed by an external CSI driver */
import io.circe._
import io.circe.generic.semiauto._

case class CSIVolumeSource(
  /* Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster. */
  driver: String,
  /* Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply. */
  fsType: Option[String] = None,
  /* NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed. */
  nodePublishSecretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  /* Specifies a read-only configuration for the volume. Defaults to false (read/write). */
  readOnly: Option[Boolean] = None,
  /* VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values. */
  volumeAttributes: Option[Map[String, String]] = None
)

object CSIVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[CSIVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[CSIVolumeSource] = deriveDecoder
}
