package io.k8s.api.core.v1

/* Adds and removes POSIX capabilities from running containers. */
import io.circe._
import io.circe.generic.semiauto._

case class Capabilities(
  /* Added capabilities */
  add: Option[Seq[String]] = None,
  /* Removed capabilities */
  drop: Option[Seq[String]] = None
)

object Capabilities {
  implicit lazy val encoder: Encoder.AsObject[Capabilities] = deriveEncoder
  implicit lazy val decoder: Decoder[Capabilities] = deriveDecoder
}
