package io.k8s.api.core.v1

/* Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class CephFSVolumeSource(
  /* Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it */
  monitors: Seq[String],
  /* Optional: Used as the mounted root, rather than the full Ceph tree, default is / */
  path: Option[String] = None,
  /* Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it */
  readOnly: Option[Boolean] = None,
  /* Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it */
  secretFile: Option[String] = None,
  /* Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it */
  secretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  /* Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it */
  user: Option[String] = None
)

object CephFSVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[CephFSVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[CephFSVolumeSource] = deriveDecoder
}
