package io.k8s.api.core.v1

/* ClientIPConfig represents the configurations of Client IP based session affinity. */
import io.circe._
import io.circe.generic.semiauto._

case class ClientIPConfig(
  /* timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours). */
  timeoutSeconds: Option[Int] = None
)

object ClientIPConfig {
  implicit lazy val encoder: Encoder.AsObject[ClientIPConfig] = deriveEncoder
  implicit lazy val decoder: Decoder[ClientIPConfig] = deriveDecoder
}
