package io.k8s.apimachinery.pkg.apis.meta.v1

/* Condition contains details for one aspect of the current state of this API Resource. */
import io.circe._
import io.circe.generic.semiauto._

case class Condition(
  /* type of condition in CamelCase or in foo.example.com/CamelCase. */
  `type`: String,
  /* status of the condition, one of True, False, Unknown. */
  status: String,
  /* lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable. */
  lastTransitionTime: io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  /* reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty. */
  reason: String,
  /* message is a human readable message indicating details about the transition. This may be an empty string. */
  message: String,
  /* observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance. */
  observedGeneration: Option[Long] = None
)

object Condition {
  implicit lazy val encoder: Encoder.AsObject[Condition] = deriveEncoder
  implicit lazy val decoder: Decoder[Condition] = deriveDecoder
}
