package io.k8s.api.core.v1

/* ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables. */
import io.circe._
import io.circe.generic.semiauto._

case class ConfigMapEnvSource(
  /* Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names */
  name: Option[String] = None,
  /* Specify whether the ConfigMap must be defined */
  optional: Option[Boolean] = None
)

object ConfigMapEnvSource {
  implicit lazy val encoder: Encoder.AsObject[ConfigMapEnvSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ConfigMapEnvSource] = deriveDecoder
}
