package io.k8s.api.core.v1

/* Selects a key from a ConfigMap. */
import io.circe._
import io.circe.generic.semiauto._

case class ConfigMapKeySelector(
  /* The key to select. */
  key: String,
  /* Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names */
  name: Option[String] = None,
  /* Specify whether the ConfigMap or its key must be defined */
  optional: Option[Boolean] = None
)

object ConfigMapKeySelector {
  implicit lazy val encoder: Encoder.AsObject[ConfigMapKeySelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ConfigMapKeySelector] = deriveDecoder
}
