package io.k8s.api.core.v1

/* ContainerStateRunning is a running state of a container. */
import io.circe._
import io.circe.generic.semiauto._

case class ContainerStateRunning(
  /* Time at which the container was last (re-)started */
  startedAt: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object ContainerStateRunning {
  implicit lazy val encoder: Encoder.AsObject[ContainerStateRunning] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStateRunning] = deriveDecoder
}
