package io.k8s.api.core.v1

/* ContainerStateTerminated is a terminated state of a container. */
import io.circe._
import io.circe.generic.semiauto._

case class ContainerStateTerminated(
  /* Exit status from the last termination of the container */
  exitCode: Int,
  /* Container's ID in the format 'docker://<container_id>' */
  containerID: Option[String] = None,
  /* Time at which the container last terminated */
  finishedAt: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Message regarding the last termination of the container */
  message: Option[String] = None,
  /* (brief) reason from the last termination of the container */
  reason: Option[String] = None,
  /* Signal from the last termination of the container */
  signal: Option[Int] = None,
  /* Time at which previous execution of the container started */
  startedAt: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object ContainerStateTerminated {
  implicit lazy val encoder: Encoder.AsObject[ContainerStateTerminated] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStateTerminated] = deriveDecoder
}
