package io.k8s.api.core.v1

/* ContainerStateWaiting is a waiting state of a container. */
import io.circe._
import io.circe.generic.semiauto._

case class ContainerStateWaiting(
  /* Message regarding why the container is not yet running. */
  message: Option[String] = None,
  /* (brief) reason the container is not yet running. */
  reason: Option[String] = None
)

object ContainerStateWaiting {
  implicit lazy val encoder: Encoder.AsObject[ContainerStateWaiting] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStateWaiting] = deriveDecoder
}
